/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.ReaderOperator;
import org.hswebframework.reactor.excel.WritableCell;
import org.hswebframework.reactor.excel.WriterOperator;
import org.hswebframework.reactor.excel.converter.RowWrapper;
import org.hswebframework.reactor.excel.spec.ReaderSpec;
import org.hswebframework.reactor.excel.spec.WriterSpec;
import org.hswebframework.reactor.excel.spi.ExcelReader;
import org.hswebframework.reactor.excel.spi.ExcelWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Consumer3;

public abstract class ReactorExcel {
    private static final Logger log = LoggerFactory.getLogger(ReactorExcel.class);
    private static final Map<String, ExcelReader> readers = new ConcurrentHashMap<String, ExcelReader>();
    private static final Map<String, ExcelWriter> writers = new ConcurrentHashMap<String, ExcelWriter>();

    public static ExcelReader lookupReader(String format) {
        ExcelReader reader = readers.get(format);
        if (reader == null) {
            throw new UnsupportedOperationException("unsupported format:" + format);
        }
        return reader;
    }

    public static ExcelWriter lookupWriter(String format) {
        ExcelWriter writer = writers.get(format);
        if (writer == null) {
            throw new UnsupportedOperationException("unsupported format:" + format);
        }
        return writer;
    }

    public static Consumer3<Map<String, Object>, String, Cell> mapWrapper() {
        return (map, header, cell) -> map.put(header, cell.value().orElse(null));
    }

    public static <T> BiConsumer<T, Cell> cell(int x, int y, BiConsumer<T, Object> handler) {
        return (instance, cell) -> {
            if (cell.getColumnIndex() == x && cell.getRowIndex() == (long)y) {
                Object value = cell.value().orElse(null);
                handler.accept(instance, value);
            }
        };
    }

    public static Flux<Map<String, Object>> readToMap(InputStream input, String format, ExcelOption ... options) {
        return ReaderSpec.readFor(ReactorExcel.lookupReader(format), LinkedHashMap::new).justReadByHeader().wrapper(ReactorExcel.mapWrapper()).read(input, options);
    }

    public static <T> ReaderSpec.ReaderSpecSelector<T> readFor(String format, Supplier<T> instance) {
        return ReaderSpec.readFor(ReactorExcel.lookupReader(format), instance);
    }

    public static <T> ReaderSpec.ReaderSpecSelector<T> xlsxReader(Supplier<T> instance) {
        return ReactorExcel.readFor("xlsx", instance);
    }

    public static <T> Flux<T> read(InputStream input, String format, RowWrapper<T> wrapper) {
        return (Flux)ReactorExcel.read(input, format).as(wrapper::convert);
    }

    public static Flux<Cell> read(InputStream input, String format) {
        return ReactorExcel.lookupReader(format).read(input, new ExcelOption[0]).cast(Cell.class);
    }

    @Deprecated
    public static ReaderOperator<Map<String, Object>> mapReader(String format) {
        return ReaderOperator.ofMap(ReactorExcel.lookupReader(format));
    }

    @Deprecated
    public static <T> ReaderOperator<T> reader(Class<T> type, String format) {
        return ReaderOperator.of(ReactorExcel.lookupReader(format), type);
    }

    public static <T> WriterOperator<T> writer(String format) {
        return WriterOperator.of(ReactorExcel.lookupWriter(format));
    }

    public static WriterSpec.WriterSpecSelector writeFor(String format) {
        return WriterSpec.writeFor(ReactorExcel.lookupWriter(format));
    }

    public static WriterSpec.WriterSpecSelector xlsxWriter() {
        return ReactorExcel.writeFor("xlsx");
    }

    public static Mono<Void> write(Flux<WritableCell> dataStream, OutputStream outputStream, String format, ExcelOption ... options) {
        return ReactorExcel.lookupWriter(format).write(dataStream, outputStream, options);
    }

    static {
        try {
            ServiceLoader.load(ExcelReader.class).forEach(reader -> {
                for (String excelFormat : reader.getSupportFormat()) {
                    readers.put(excelFormat, (ExcelReader)reader);
                }
            });
            ServiceLoader.load(ExcelWriter.class).forEach(reader -> {
                for (String excelFormat : reader.getSupportFormat()) {
                    writers.put(excelFormat, (ExcelWriter)reader);
                }
            });
        }
        catch (Exception e) {
            log.error("load excel reader error", (Throwable)e);
        }
    }
}

