/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.csv;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.csv.CharsetOption;
import org.hswebframework.reactor.excel.csv.CsvCell;
import org.hswebframework.reactor.excel.spi.ExcelReader;
import reactor.core.publisher.Flux;

public class CsvReader
implements ExcelReader {
    @Override
    public String[] getSupportFormat() {
        return new String[]{"csv"};
    }

    public Flux<CsvCell> read(InputStream inputStream, ExcelOption ... options) {
        return Flux.create(sink -> {
            try (CSVParser parser = CSVFormat.EXCEL.parse((Reader)new InputStreamReader(inputStream, this.getCharset(options)));){
                int rowIndex = 0;
                for (CSVRecord record : parser) {
                    if (sink.isCancelled()) break;
                    int last = record.size() - 1;
                    for (int i = 0; i < last; ++i) {
                        sink.next((Object)new CsvCell(rowIndex, i, record.get(i), false));
                    }
                    sink.next((Object)new CsvCell(rowIndex, last, record.get(last), true));
                    ++rowIndex;
                }
                sink.complete();
            }
            catch (Throwable err) {
                sink.error(err);
            }
        });
    }

    private Charset getCharset(ExcelOption ... options) {
        for (ExcelOption option : options) {
            if (!option.isWrapFor(CharsetOption.class)) continue;
            return option.unwrap(CharsetOption.class).getCharset();
        }
        return StandardCharsets.UTF_8;
    }

    @Override
    public boolean isSupportMultiSheet() {
        return false;
    }
}

