/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.poi;

import java.math.BigDecimal;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.hswebframework.reactor.excel.BoundedCell;
import org.hswebframework.reactor.excel.CellDataType;

class PoiCell
implements BoundedCell {
    private int sheetIndex;
    private Cell cell;
    private boolean endOfRow;
    private Object value;

    PoiCell(int sheetIndex, Cell cell, boolean end) {
        this.sheetIndex = sheetIndex;
        this.cell = cell;
        this.endOfRow = end;
        this.value = this.convertValue();
    }

    private Object convertValue() {
        if (this.cell == null) {
            return null;
        }
        switch (this.cell.getCellType()) {
            case BOOLEAN: {
                return this.cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (this.isCellDateFormatted()) {
                    return this.cell.getDateCellValue();
                }
                return this.convertToNumber(this.cell);
            }
            case STRING: {
                return this.cell.getRichStringCellValue().getString();
            }
            case FORMULA: {
                FormulaEvaluator evaluator = this.cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                CellValue cellValue = evaluator.evaluate(this.cell);
                switch (cellValue.getCellType()) {
                    case BOOLEAN: {
                        return this.cell.getBooleanCellValue();
                    }
                    case NUMERIC: {
                        if (this.isCellDateFormatted()) {
                            return this.cell.getDateCellValue();
                        }
                        return this.convertToNumber(this.cell);
                    }
                    case BLANK: {
                        return "";
                    }
                }
                return cellValue.getStringValue();
            }
        }
        return this.cell.getStringCellValue();
    }

    private Number convertToNumber(Cell cell) {
        BigDecimal value = new BigDecimal(cell.toString());
        if (value.scale() == 0) {
            return value.longValue();
        }
        BigDecimal[] result = value.divideAndRemainder(BigDecimal.ONE);
        if (result[1].equals(BigDecimal.valueOf(0.0))) {
            return value.longValue();
        }
        return value;
    }

    public boolean isCellDateFormatted() {
        if (this.cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = this.cell.getNumericCellValue();
        if (DateUtil.isValidExcelDate((double)d)) {
            CellStyle style = this.cell.getCellStyle();
            if (style == null) {
                return false;
            }
            short i = style.getDataFormat();
            if (i == 58 || i == 31) {
                return true;
            }
            String f = style.getDataFormatString();
            f = f.replaceAll("[\"|']", "").replaceAll("[\u5e74|\u6708|\u65e5|\u65f6|\u5206|\u79d2|\u6beb\u79d2|\u5fae\u79d2]", "");
            bDate = DateUtil.isADateFormat((int)i, (String)f);
        }
        return bDate;
    }

    @Override
    public int getSheetIndex() {
        return this.sheetIndex;
    }

    @Override
    public String getSheetName() {
        return this.cell.getSheet().getSheetName();
    }

    @Override
    public long getRowIndex() {
        return this.cell.getRowIndex();
    }

    @Override
    public int getColumnIndex() {
        return this.cell.getColumnIndex();
    }

    @Override
    public int getNumberOfColumns() {
        return this.cell.getRow().getPhysicalNumberOfCells();
    }

    @Override
    public int getNumberOfSheets() {
        return this.cell.getSheet().getWorkbook().getNumberOfSheets();
    }

    @Override
    public int getNumberOfRows() {
        return this.cell.getSheet().getPhysicalNumberOfRows();
    }

    @Override
    public Optional<Object> value() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public CellDataType getType() {
        switch (this.cell.getCellType()) {
            case NUMERIC: {
                return CellDataType.NUMBER;
            }
            case FORMULA: {
                return CellDataType.FORMULA;
            }
            case BOOLEAN: {
                return CellDataType.BOOLEAN;
            }
        }
        if (this.isCellDateFormatted()) {
            return CellDataType.DATE_TIME;
        }
        return CellDataType.STRING;
    }

    public Cell getCell() {
        return this.cell;
    }

    @Override
    public boolean isEndOfRow() {
        return this.endOfRow;
    }

    public Object getValue() {
        return this.value;
    }

    public PoiCell(int sheetIndex, Cell cell, boolean endOfRow, Object value) {
        this.sheetIndex = sheetIndex;
        this.cell = cell;
        this.endOfRow = endOfRow;
        this.value = value;
    }
}

