/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.poi;

import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.InSheetCell;
import org.hswebframework.reactor.excel.OptionSupport;
import org.hswebframework.reactor.excel.Options;
import org.hswebframework.reactor.excel.WritableCell;
import org.hswebframework.reactor.excel.poi.options.CellOption;
import org.hswebframework.reactor.excel.poi.options.RowOption;
import org.hswebframework.reactor.excel.poi.options.SheetOption;
import org.hswebframework.reactor.excel.poi.options.WorkbookOption;
import org.hswebframework.reactor.excel.spi.ExcelWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PoiExcelWriter
implements ExcelWriter {
    private static final Logger log = LoggerFactory.getLogger(PoiExcelWriter.class);

    @Override
    public String[] getSupportFormat() {
        return new String[]{"xlsx"};
    }

    protected Workbook createWorkBook() {
        return new SXSSFWorkbook();
    }

    protected void writeAndClose(Workbook workbook, OutputStream stream) {
        try {
            workbook.write(stream);
            workbook.close();
            stream.flush();
            stream.close();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw e;
        }
    }

    private void handleWriteOption(Workbook workbook, Options ... options) {
        for (Options opts : options) {
            opts.handleOptions(WorkbookOption.class, opt -> opt.workbook(workbook));
        }
    }

    private void handleWriteOption(Sheet sheet, Options ... options) {
        for (Options opts : options) {
            opts.handleOptions(SheetOption.class, opt -> opt.sheet(sheet));
        }
    }

    private void handleWriteOption(Row row, Options ... options) {
        for (Options opts : options) {
            opts.handleOptions(RowOption.class, opt -> opt.row(row));
        }
    }

    private void handleWriteOption(org.apache.poi.ss.usermodel.Cell poiCell, WritableCell cell, Options ... options) {
        for (Options opts : options) {
            opts.handleOptions(CellOption.class, opt -> opt.cell(poiCell, cell));
        }
    }

    @Override
    public Mono<Void> write(Flux<WritableCell> dataStream, OutputStream outputStream, ExcelOption ... options) {
        return Mono.defer(() -> {
            Options opts = options.length > 0 ? Options.of(Arrays.asList(options)) : Options.empty();
            Workbook workbook = this.createWorkBook();
            this.handleWriteOption(workbook, opts);
            return dataStream.sort(Comparator.comparing(InSheetCell::getSheetIndex).thenComparing(Cell::getRowIndex).thenComparing(Cell::getColumnIndex)).doOnNext(cell -> {
                org.apache.poi.ss.usermodel.Cell poiCell;
                Sheet sheet;
                Options cellOpts = cell instanceof OptionSupport ? ((OptionSupport)((Object)cell)).options() : Options.empty();
                try {
                    sheet = workbook.getSheetAt(cell.getSheetIndex());
                }
                catch (IllegalArgumentException e) {
                    sheet = workbook.createSheet();
                    this.handleWriteOption(sheet, opts, cellOpts);
                }
                int rowIndex = (int)cell.getRowIndex();
                Row row = sheet.getRow(rowIndex);
                if (row == null) {
                    row = sheet.createRow(rowIndex);
                    this.handleWriteOption(row, opts, cellOpts);
                }
                if ((poiCell = row.getCell(cell.getColumnIndex())) == null) {
                    poiCell = row.createCell(cell.getColumnIndex());
                }
                this.wrapCell(poiCell, (WritableCell)cell);
                this.handleWriteOption(poiCell, (WritableCell)cell, opts, cellOpts);
            }).then(Mono.fromRunnable(() -> this.writeAndClose(workbook, outputStream))).then();
        });
    }

    protected void wrapCell(org.apache.poi.ss.usermodel.Cell poiCell, WritableCell cell) {
        Date val = cell.value().orElse(null);
        if (val == null) {
            poiCell.setBlank();
            return;
        }
        switch (cell.getType()) {
            case BOOLEAN: {
                poiCell.setCellValue(((Boolean)((Object)val)).booleanValue());
                break;
            }
            case NUMBER: {
                if (val instanceof Number) {
                    poiCell.setCellValue(((Number)((Object)val)).doubleValue());
                }
                poiCell.setCellValue(String.valueOf(val));
                break;
            }
            case DATE_TIME: {
                if (val instanceof Long) {
                    val = new Date();
                }
                if (val instanceof Date) {
                    poiCell.setCellValue(val);
                } else if (val instanceof LocalDate) {
                    poiCell.setCellValue((LocalDate)((Object)val));
                } else if (val instanceof LocalDateTime) {
                    poiCell.setCellValue((LocalDateTime)((Object)val));
                }
                poiCell.setCellValue(String.valueOf(val));
                break;
            }
            case FORMULA: {
                poiCell.setCellFormula(String.valueOf(val));
                break;
            }
            default: {
                poiCell.setCellValue(String.valueOf(val));
            }
        }
    }

    @Override
    public boolean isSupportMultiSheet() {
        return true;
    }
}

