/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.spec;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.hswebframework.reactor.excel.BoundedCell;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.InSheetCell;
import org.hswebframework.reactor.excel.spec.ReaderSpec;
import org.hswebframework.reactor.excel.spi.ExcelReader;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Consumer3;

class DefaultReaderSpec<T>
implements ReaderSpec.MultiSheetHeaderReaderSpec<T>,
ReaderSpec.MultiSheetCellReaderSpec<T>,
ReaderSpec.SheetHeaderReaderSpec<T>,
ReaderSpec.SheetReaderSpec<T>,
ReaderSpec.ReaderSpecSelector<T> {
    private final Object GLOBAL_WRAPPER = new Object();
    private final Map<Object, Consumer3<T, String, Cell>> wrappers = new HashMap<Object, Consumer3<T, String, Cell>>();
    private final ExcelReader reader;
    private final Supplier<? extends T> instanceSupplier;
    private final Set<Long> skipRows = new HashSet<Long>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private int headerRow = 0;
    private int firstHeaderColumnIndex = 0;
    private BiPredicate<T, InSheetCell> newInstancePredicate = (t, cell) -> cell.isEndOfRow();
    private boolean headerMode = false;

    public DefaultReaderSpec(ExcelReader reader, Supplier<? extends T> instanceSupplier) {
        this.reader = reader;
        this.instanceSupplier = instanceSupplier;
    }

    @Override
    public Flux<T> read(InputStream stream, ExcelOption ... options) {
        if (this.wrappers.size() == 0) {
            throw new UnsupportedOperationException("wrapper can not be empty.");
        }
        return this.transfer(this.reader.read(stream, options));
    }

    Flux<T> transfer(Flux<? extends Cell> cells) {
        AtomicReference current = new AtomicReference();
        HashMap headerMapping = new HashMap();
        return cells.cast(InSheetCell.class).handle((cell, sink) -> {
            Consumer3<T, String, Cell> wrapper;
            if (this.skipRows.contains(cell.getRowIndex())) {
                return;
            }
            if (this.headerMode && cell.getRowIndex() == (long)this.headerRow) {
                headerMapping.put(cell.getColumnIndex(), cell);
                return;
            }
            Object instance = current.get();
            if (instance == null) {
                instance = this.instanceSupplier.get();
                current.set(instance);
            }
            if ((wrapper = this.wrappers.get(this.GLOBAL_WRAPPER)) == null) {
                wrapper = this.wrappers.get(cell.getSheetIndex());
            }
            if (wrapper == null) {
                wrapper = this.wrappers.get(cell.getSheetName());
            }
            if (wrapper == null) {
                return;
            }
            if (this.headerMode) {
                InSheetCell header = (InSheetCell)headerMapping.get(cell.getColumnIndex());
                String headerText = null;
                if (header != null && (headerText = (String)header.valueAsText().orElse(null)) != null && this.headers.size() > 0) {
                    headerText = this.headers.get(headerText);
                }
                if (headerText != null) {
                    wrapper.accept(instance, (Object)headerText, cell);
                }
            } else {
                wrapper.accept(instance, null, cell);
            }
            if (this.newInstancePredicate.test(instance, (InSheetCell)cell)) {
                sink.next(instance);
                current.set(null);
            }
        }).concatWith((Publisher)Mono.fromSupplier(current::get));
    }

    @Override
    public DefaultReaderSpec<T> sheet(int index, BiConsumer<T, BoundedCell> wrapper) {
        return this.addBoundedWrapper(index, (instance, header, cell) -> wrapper.accept((Object)instance, (BoundedCell)cell));
    }

    @Override
    public DefaultReaderSpec<T> sheet(String name, BiConsumer<T, BoundedCell> wrapper) {
        return this.addBoundedWrapper(name, (instance, header, cell) -> wrapper.accept((Object)instance, (BoundedCell)cell));
    }

    @Override
    public DefaultReaderSpec<T> header(String from, String to) {
        this.headerMode = true;
        this.headers.put(from, to);
        return this;
    }

    @Override
    public DefaultReaderSpec<T> headers(Map<String, String> headers) {
        this.headerMode = true;
        this.headers.putAll(headers);
        return this;
    }

    @Override
    public DefaultReaderSpec<T> sheet(int index, Consumer3<T, String, BoundedCell> wrapper) {
        this.headerMode = true;
        return this.addBoundedWrapper(index, wrapper);
    }

    @Override
    public DefaultReaderSpec<T> sheet(String name, Consumer3<T, String, BoundedCell> wrapper) {
        this.headerMode = true;
        return this.addBoundedWrapper(name, wrapper);
    }

    private DefaultReaderSpec<T> addWrapper(Object key, Consumer3<T, String, Cell> wrapper) {
        this.wrappers.put(key, wrapper);
        return this;
    }

    private DefaultReaderSpec<T> addBoundedWrapper(Object key, Consumer3<T, String, BoundedCell> wrapper) {
        this.checkReaderSupportMultiSheet();
        this.wrappers.put(key, (t, header, cell) -> wrapper.accept(t, header, (Object)((BoundedCell)cell)));
        return this;
    }

    @Override
    public DefaultReaderSpec<T> oneInstanceEachRow() {
        return this.instanceCondition((T instance, U cell) -> ((Cell)cell).isEndOfRow());
    }

    @Override
    public DefaultReaderSpec<T> oneInstanceEachSheet() {
        this.checkReaderSupportMultiSheet();
        return this.instanceCondition((T instance, U cell) -> ((BoundedCell)cell).isLastRow() && ((BoundedCell)cell).isLastColumn());
    }

    @Override
    public DefaultReaderSpec<T> oneInstanceAllSheets() {
        return this.instanceCondition((T instance, U cell) -> false);
    }

    @Override
    public DefaultReaderSpec<T> wrapper(BiConsumer<T, Cell> wrapper) {
        return this.addWrapper(this.GLOBAL_WRAPPER, (t, header, cell) -> wrapper.accept((Object)t, (Cell)cell));
    }

    @Override
    public DefaultReaderSpec<T> wrapper(Consumer3<T, String, Cell> wrapper) {
        this.headerMode = true;
        return this.addWrapper(this.GLOBAL_WRAPPER, wrapper);
    }

    @Override
    public DefaultReaderSpec<T> instanceCondition(BiPredicate predicate) {
        this.newInstancePredicate = predicate;
        return this;
    }

    @Override
    public DefaultReaderSpec<T> skipRow(int rowIndex) {
        this.skipRows.add(Long.valueOf(rowIndex));
        return this;
    }

    @Override
    public DefaultReaderSpec<T> headerRow(int rowIndex) {
        this.headerMode = true;
        this.headerRow = rowIndex;
        return this;
    }

    @Override
    public ReaderSpec.SheetReaderSpec<T> justRead() {
        return this;
    }

    @Override
    public ReaderSpec.SheetHeaderReaderSpec<T> justReadByHeader() {
        this.headerMode = true;
        return this;
    }

    @Override
    public ReaderSpec.MultiSheetCellReaderSpec<T> multiSheet() {
        return this;
    }

    @Override
    public ReaderSpec.MultiSheetHeaderReaderSpec<T> multiSheetByHeader() {
        this.headerMode = true;
        return this;
    }

    public void checkReaderSupportMultiSheet() {
        if (!this.reader.isSupportMultiSheet()) {
            throw new UnsupportedOperationException("reader " + this.reader + " not supported multi sheet");
        }
    }
}

