/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.spec;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Sheet;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.WritableCell;
import org.hswebframework.reactor.excel.poi.options.PoiWriteOptions;
import org.hswebframework.reactor.excel.poi.options.SheetOption;
import org.hswebframework.reactor.excel.spec.DefaultSheetSpec;
import org.hswebframework.reactor.excel.spec.SheetSpec;
import org.hswebframework.reactor.excel.spec.WriterSpec;
import org.hswebframework.reactor.excel.spi.ExcelWriter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultWriterSepc
implements WriterSpec.MultiSheetWriterSpec,
WriterSpec.WriterSpecSelector {
    private final List<ExcelOption> options = new CopyOnWriteArrayList<ExcelOption>();
    private final Map<Integer, Flux<WritableCell>> cells = new LinkedHashMap<Integer, Flux<WritableCell>>();
    private int maxSheetSize;
    private ExcelWriter writer;

    @Override
    public Mono<Void> write(OutputStream output) {
        return this.writer.write((Flux<WritableCell>)Flux.concat(this.cells.values()), output, this.options.toArray(new ExcelOption[0]));
    }

    @Override
    public WriterSpec.MultiSheetWriterSpec option(ExcelOption ... options) {
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    @Override
    public DefaultWriterSepc sheet(Consumer<SheetSpec.HeaderSheetSpec> consumer) {
        return this.sheet(this.cells.size(), (Consumer)consumer);
    }

    @Override
    public DefaultWriterSepc cellSheet(Consumer<SheetSpec.CellSheetSpec> consumer) {
        return this.cellSheet(this.cells.size(), (Consumer)consumer);
    }

    @Override
    public DefaultWriterSepc sheet(int index, Consumer<SheetSpec.HeaderSheetSpec> consumer) {
        this.checkSheetSize();
        DefaultSheetSpec sheetSpec = new DefaultSheetSpec(index);
        consumer.accept(sheetSpec);
        this.cells.put(index, (Flux<WritableCell>)sheetSpec.cells().map(cell -> WritableCell.of(cell, index)));
        if (null != sheetSpec.getName() && sheetSpec.getName().length() > 0) {
            this.option(PoiWriteOptions.sheetName(index, sheetSpec.getName()));
        }
        this.addSheetOption(index, sheetSpec.getOptions());
        return this;
    }

    @Override
    public DefaultWriterSepc cellSheet(int index, Consumer<SheetSpec.CellSheetSpec> consumer) {
        this.checkSheetSize();
        return this.sheet(index, consumer::accept);
    }

    private void addSheetOption(int index, Collection<SheetOption> options) {
        this.options.add(SheetOption.of(sheet -> {
            if (sheet.getWorkbook().getSheetIndex(sheet) == index) {
                for (SheetOption option : options) {
                    option.sheet((Sheet)sheet);
                }
            }
        }));
    }

    private void checkSheetSize() {
        if (this.cells.size() >= this.maxSheetSize) {
            throw new IllegalStateException("Out of Sheet size limit : " + this.maxSheetSize);
        }
    }

    @Override
    public WriterSpec.SheetWriterSpec justWrite() {
        return this;
    }

    @Override
    public WriterSpec.MultiSheetWriterSpec multiSheet() {
        if (!this.writer.isSupportMultiSheet()) {
            throw new UnsupportedOperationException("Writer " + this.writer + " unsupported multi sheet");
        }
        return this;
    }

    public DefaultWriterSepc(int maxSheetSize, ExcelWriter writer) {
        this.maxSheetSize = maxSheetSize;
        this.writer = writer;
    }
}

