/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.spec;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.ExcelHeader;
import org.hswebframework.reactor.excel.poi.options.SheetOption;
import reactor.core.publisher.Flux;

public interface SheetSpec {
    public SheetSpec name(String var1);

    public SheetSpec option(SheetOption ... var1);

    public static interface HeaderSheetSpec
    extends CellSheetSpec {
        public HeaderSheetSpec header(String var1, String var2);

        public HeaderSheetSpec header(ExcelHeader var1);

        public HeaderSheetSpec headers(Collection<ExcelHeader> var1);

        public HeaderSheetSpec handle(Consumer<HeaderSheetSpec> var1);

        public HeaderSheetSpec firstRowIndex(int var1);

        public HeaderSheetSpec rows(Flux<Map<String, Object>> var1);

        @Override
        public HeaderSheetSpec name(String var1);

        @Override
        public HeaderSheetSpec option(SheetOption ... var1);
    }

    public static interface CellSheetSpec
    extends SheetSpec {
        @Override
        public CellSheetSpec name(String var1);

        @Override
        public CellSheetSpec option(SheetOption ... var1);

        public CellSheetSpec cells(Flux<Cell> var1);

        public CellSheetSpec cell(Cell var1);

        default public CellSheetSpec cells(Cell ... cells) {
            return this.cells((Flux<Cell>)Flux.fromArray((Object[])cells));
        }

        default public CellSheetSpec cells(Iterable<Cell> cells) {
            return this.cells((Flux<Cell>)Flux.fromIterable(cells));
        }

        default public CellSheetSpec cell(int x, int y, Object value) {
            return this.cell(Cell.of(x, y, value));
        }
    }
}

