/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.utils;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamUtils.class);

    public static Flux<byte[]> buffer(int buffer, Function<OutputStream, Mono<Void>> streamConsumer) {
        return Flux.create(sink -> {
            BufferedOutputStream stream = new BufferedOutputStream(new OutputStream((FluxSink)sink){
                final /* synthetic */ FluxSink val$sink;
                {
                    this.val$sink = fluxSink;
                }

                @Override
                public void write(byte[] b, int off, int len) {
                    if (len == b.length) {
                        this.val$sink.next((Object)b);
                    } else {
                        this.val$sink.next((Object)Arrays.copyOfRange(b, off, off + len));
                    }
                }

                @Override
                public void write(byte[] b) {
                    this.val$sink.next((Object)b);
                }

                @Override
                public void write(int b) {
                    this.val$sink.next((Object)new byte[]{(byte)b});
                }
            }, buffer, (FluxSink)sink){
                final /* synthetic */ FluxSink val$sink;
                {
                    this.val$sink = fluxSink;
                    super(x0, x1);
                }

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        this.val$sink.complete();
                    }
                }
            };
            sink.onDispose(((Mono)streamConsumer.apply(stream)).doOnError(arg_0 -> ((FluxSink)sink).error(arg_0)).subscriberContext(sink.currentContext()).subscribe());
        });
    }

    public static void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Throwable err) {
            log.warn(err.getMessage(), err);
        }
    }
}

