/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.Options;

class DefaultOptions
implements Options {
    private final List<ExcelOption> options = new ArrayList<ExcelOption>();

    DefaultOptions() {
    }

    DefaultOptions(List<ExcelOption> options) {
        this.options.addAll((Collection<ExcelOption>)Objects.requireNonNull(options, "options can not be null"));
    }

    @Override
    public List<ExcelOption> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    @Override
    public <T extends ExcelOption> List<T> getOptions(Class<T> type) {
        return this.options.stream().filter(opt -> opt.isWrapFor(type)).map(opt -> (ExcelOption)opt.unwrap(type)).collect(Collectors.toList());
    }

    @Override
    public Options option(ExcelOption option) {
        this.options.add(option);
        return this;
    }

    @Override
    public Options merge(Options options) {
        return this.merge(options.getOptions());
    }

    @Override
    public Options merge(List<ExcelOption> options) {
        this.options.addAll(options);
        return this;
    }
}

