/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.hswebframework.reactor.excel.CellDataType;
import org.hswebframework.reactor.excel.ExcelHeader;
import org.hswebframework.reactor.excel.WritableCell;
import reactor.core.publisher.Flux;

public class MapRowExpander
implements BiFunction<Long, Map<String, Object>, Flux<WritableCell>> {
    private final List<ExcelHeader> headers = new ArrayList<ExcelHeader>();
    private final int sheetIndex;

    public MapRowExpander() {
        this(0);
    }

    public MapRowExpander(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public MapRowExpander header(String key, String header, CellDataType type) {
        return this.header(new ExcelHeader(key, header, type));
    }

    public MapRowExpander header(String key, String header) {
        return this.header(key, header, CellDataType.STRING);
    }

    public MapRowExpander header(ExcelHeader header) {
        this.headers.add(header);
        return this;
    }

    public MapRowExpander headers(Collection<ExcelHeader> headers) {
        this.headers.addAll(headers);
        return this;
    }

    public Flux<WritableCell> headers(long rowIndex) {
        return Flux.fromIterable(this.getHeaders()).index((index, header) -> WritableCell.of(this.sheetIndex, rowIndex, index.intValue(), header.getType(), header.getText(), index == (long)(this.getHeaders().size() - 1)));
    }

    @Override
    public synchronized Flux<WritableCell> apply(Long rowIndex, Map<String, Object> val) {
        return Flux.fromIterable(this.headers).index().map(header -> WritableCell.of(this.sheetIndex, rowIndex, ((Long)header.getT1()).intValue(), ((ExcelHeader)header.getT2()).getType(), this.getValue(((ExcelHeader)header.getT2()).getKey(), val), ((Long)header.getT1()).intValue() == this.headers.size() - 1));
    }

    protected Object getValue(String key, Map<String, Object> map) {
        Object val = map.get(key);
        if (val != null) {
            return val;
        }
        if (key.contains(".") || key.contains("[")) {
            try {
                return BeanUtilsBean.getInstance().getPropertyUtils().getProperty(map, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public List<ExcelHeader> getHeaders() {
        return this.headers;
    }
}

