/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.WritableCell;
import org.hswebframework.reactor.excel.spi.ExcelWriter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CsvWriter
implements ExcelWriter {
    @Override
    public String[] getSupportFormat() {
        return new String[]{"csv"};
    }

    private void doWrite(CSVPrinter printer, Cell cell) {
        printer.print((Object)cell.valueAsText().orElse(""));
        if (cell.isEndOfRow()) {
            printer.println();
        }
    }

    private void closePrinter(CSVPrinter printer) {
        printer.close();
    }

    @Override
    public Mono<Void> write(Flux<WritableCell> dataStream, OutputStream outputStream, ExcelOption ... options) {
        return Mono.defer(() -> {
            try {
                CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter(outputStream), CSVFormat.EXCEL);
                return dataStream.doOnNext(cell -> this.doWrite(printer, (Cell)cell)).then(Mono.fromRunnable(() -> this.closePrinter(printer)));
            }
            catch (IOException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    @Override
    public boolean isSupportMultiSheet() {
        return false;
    }
}

