/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.poi;

import java.io.InputStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.hswebframework.reactor.excel.BoundedCell;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.spi.ExcelReader;
import reactor.core.publisher.Flux;

public class PoiExcelReader
implements ExcelReader {
    @Override
    public String[] getSupportFormat() {
        return new String[]{"xls", "xlsx"};
    }

    public Flux<BoundedCell> read(InputStream inputStream, ExcelOption ... options) {
        return Flux.create(sink -> {
            try (Workbook wbs = WorkbookFactory.create((InputStream)inputStream);){
                int sheetSize = wbs.getNumberOfSheets();
                for (int x = 0; x < sheetSize; ++x) {
                    Sheet sheet = wbs.getSheetAt(x);
                    int rowNum = sheet.getLastRowNum();
                    if (rowNum <= 0) continue;
                    Row row = sheet.getRow(0);
                    int colNum = row.getPhysicalNumberOfCells();
                    int i = 0;
                }
                sink.complete();
            }
            catch (Throwable e) {
                sink.error(e);
            }
        });
    }

    @Override
    public boolean isSupportMultiSheet() {
        return true;
    }
}

