/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.WritableCell;
import org.hswebframework.reactor.excel.spi.ExcelWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CsvWriter
implements ExcelWriter {
    private static final Logger log = LoggerFactory.getLogger(CsvWriter.class);

    @Override
    public String[] getSupportFormat() {
        return new String[]{"csv"};
    }

    private void doWrite(CSVPrinter printer, Cell cell) {
        printer.print((Object)cell.valueAsText().orElse(""));
        if (cell.isEndOfRow()) {
            printer.println();
        }
    }

    private void closePrinter(CSVPrinter printer) {
        try {
            printer.close();
        }
        catch (Throwable err) {
            log.warn("close CSVPrinter error", err);
        }
    }

    @Override
    public Mono<Void> write(Flux<WritableCell> dataStream, OutputStream outputStream, ExcelOption ... options) {
        return Mono.defer(() -> {
            try {
                CSVPrinter printer = new CSVPrinter((Appendable)new OutputStreamWriter(outputStream), CSVFormat.EXCEL);
                return dataStream.doOnNext(cell -> this.doWrite(printer, (Cell)cell)).doFinally(f -> this.closePrinter(printer)).then();
            }
            catch (IOException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    @Override
    public boolean isSupportMultiSheet() {
        return false;
    }
}

