/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.poi.options;

import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.hswebframework.reactor.excel.poi.options.SheetOption;

public class AddNormalPullDownSheetOption
implements SheetOption {
    private final int index;
    private final String[] data;
    private final int firstRow;
    private final int endRow;
    private final int firstCol;
    private final int endCol;
    private final int total;
    public static final int MAX_ROW = 1048575;

    public AddNormalPullDownSheetOption(int index, int firstRow, int endRow, int firstCol, int endCol, String ... data) {
        this.index = index;
        this.data = data;
        this.firstRow = firstRow;
        this.endRow = endRow;
        this.firstCol = firstCol;
        this.endCol = endCol;
        this.total = this.initTotal();
    }

    @Override
    public void sheet(Sheet sheet) {
        if (sheet.getWorkbook().getSheetIndex(sheet) == this.index) {
            DataValidationHelper helper = sheet.getDataValidationHelper();
            if (!(helper instanceof XSSFDataValidationHelper)) {
                return;
            }
            if (this.total <= 255) {
                this.addValidationData(sheet, helper.createExplicitListConstraint(this.data));
            } else {
                if (this.index > 0) {
                    return;
                }
                String listFormulaSheet = this.toString();
                Workbook workbook = sheet.getWorkbook();
                Sheet hidden = this.createSheet(workbook, 1, listFormulaSheet);
                int length = this.data.length;
                for (int i = 0; i < length; ++i) {
                    hidden.createRow(i).createCell(0).setCellValue(this.data[i]);
                }
                workbook.setSheetHidden(1, true);
                this.createListFormula(workbook, listFormulaSheet, listFormulaSheet + "!$A$1:$A$" + this.data.length);
                this.addValidationData(sheet, helper.createFormulaListConstraint(listFormulaSheet));
            }
        }
    }

    public void addValidationData(Sheet sheet, DataValidationConstraint dataValidationConstraint) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidation validation = helper.createValidation(dataValidationConstraint, new CellRangeAddressList(this.firstRow, this.endRow, this.firstCol, this.endCol));
        validation.setSuppressDropDownArrow(true);
        validation.setShowErrorBox(true);
        sheet.addValidationData(validation);
    }

    private void createListFormula(Workbook workbook, String hiddenName, String formulaText) {
        Name listFormula = workbook.createName();
        listFormula.setNameName(hiddenName);
        listFormula.setRefersToFormula(formulaText);
    }

    private Sheet createSheet(Workbook workbook, int index, String name) {
        try {
            return workbook.getSheetAt(index);
        }
        catch (IllegalArgumentException e) {
            return workbook.createSheet(name);
        }
    }

    private int initTotal() {
        int total = 0;
        for (String str : this.data) {
            total += str.length();
        }
        return total + this.data.length - 1;
    }

    public String toString() {
        return "sheet" + this.index + "_" + this.firstRow + "." + this.endRow + "_" + this.firstCol + "." + this.endCol;
    }
}

