/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.logging.aop;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hswebframework.web.aop.MethodInterceptorHolder;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.logger.ReactiveLogger;
import org.hswebframework.web.logging.AccessLogger;
import org.hswebframework.web.logging.AccessLoggerInfo;
import org.hswebframework.web.logging.LoggerDefine;
import org.hswebframework.web.logging.RequestInfo;
import org.hswebframework.web.logging.aop.AccessLoggerParser;
import org.hswebframework.web.logging.events.AccessLoggerAfterEvent;
import org.hswebframework.web.logging.events.AccessLoggerBeforeEvent;
import org.hswebframework.web.utils.ReactiveWebUtils;
import org.reactivestreams.Publisher;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class ReactiveAopAccessLoggerSupport
extends StaticMethodMatcherPointcutAdvisor
implements WebFilter {
    @Autowired(required=false)
    private final List<AccessLoggerParser> loggerParsers = new ArrayList<AccessLoggerParser>();
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    private final Map<CacheKey, LoggerDefine> defineCache = new ConcurrentReferenceHashMap();
    private static final LoggerDefine UNSUPPORTED = new LoggerDefine();

    public ReactiveAopAccessLoggerSupport() {
        this.setAdvice((Advice)((MethodInterceptor)methodInvocation -> {
            MethodInterceptorHolder methodInterceptorHolder = MethodInterceptorHolder.create((MethodInvocation)methodInvocation);
            AccessLoggerInfo info = this.createLogger(methodInterceptorHolder);
            Object response = methodInvocation.proceed();
            if (response instanceof Mono) {
                return this.wrapMonoResponse((Mono)response, info).contextWrite((ContextView)Context.of(AccessLoggerInfo.class, (Object)info));
            }
            if (response instanceof Flux) {
                return this.wrapFluxResponse((Flux)response, info).contextWrite((ContextView)Context.of(AccessLoggerInfo.class, (Object)info));
            }
            return response;
        }));
    }

    private Mono<RequestInfo> currentRequestInfo(ContextView context) {
        if (context.hasKey(RequestInfo.class)) {
            RequestInfo info = (RequestInfo)context.get(RequestInfo.class);
            ReactiveLogger.log((ContextView)context, ctx -> info.setContext(new HashMap(ctx)));
            return Mono.just((Object)info);
        }
        return Mono.empty();
    }

    protected Flux<?> wrapFluxResponse(Flux<?> flux, AccessLoggerInfo loggerInfo) {
        return Flux.deferContextual(ctx -> this.currentRequestInfo((ContextView)ctx).doOnNext(arg_0 -> ((AccessLoggerInfo)loggerInfo).putAccessInfo(arg_0)).then(this.beforeRequest(loggerInfo)).thenMany((Publisher)flux).doOnError(arg_0 -> ((AccessLoggerInfo)loggerInfo).setException(arg_0)).doFinally(signal -> this.completeRequest(loggerInfo, (ContextView)ctx)));
    }

    private Mono<Void> beforeRequest(AccessLoggerInfo loggerInfo) {
        AccessLoggerBeforeEvent event = new AccessLoggerBeforeEvent(loggerInfo);
        return Authentication.currentReactive().flatMap(auth -> {
            loggerInfo.putContext("userId", (Object)auth.getUser().getId());
            loggerInfo.putContext("username", (Object)auth.getUser().getUsername());
            loggerInfo.putContext("userName", (Object)auth.getUser().getName());
            return ReactiveLogger.mdc((String[])new String[]{"userId", auth.getUser().getId(), "username", auth.getUser().getUsername(), "userName", auth.getUser().getName()}).thenReturn(auth);
        }).then(Mono.defer(() -> event.publish(this.eventPublisher)));
    }

    private void completeRequest(AccessLoggerInfo loggerInfo, ContextView ctx) {
        loggerInfo.setResponseTime(System.currentTimeMillis());
        new AccessLoggerAfterEvent(loggerInfo).publish(this.eventPublisher).contextWrite(ctx).subscribe();
    }

    protected Mono<?> wrapMonoResponse(Mono<?> mono, AccessLoggerInfo loggerInfo) {
        return this.wrapFluxResponse(mono.flux(), loggerInfo).singleOrEmpty();
    }

    private LoggerDefine createDefine(MethodInterceptorHolder holder) {
        return this.loggerParsers.stream().filter(parser -> parser.support(ClassUtils.getUserClass((Object)holder.getTarget()), holder.getMethod())).findAny().map(parser -> parser.parse(holder)).orElse(UNSUPPORTED);
    }

    protected AccessLoggerInfo createLogger(MethodInterceptorHolder holder) {
        AccessLoggerInfo info = new AccessLoggerInfo();
        info.setId((String)IDGenerator.MD5.generate());
        info.setRequestTime(System.currentTimeMillis());
        LoggerDefine define = this.defineCache.computeIfAbsent(new CacheKey(ClassUtils.getUserClass((Object)holder.getTarget()), holder.getMethod()), method -> this.createDefine(holder));
        if (define != null) {
            info.setAction(define.getAction());
            info.setDescribe(define.getDescribe());
        }
        ConcurrentHashMap<String, Object> value = new ConcurrentHashMap<String, Object>();
        String[] names = holder.getArgumentsNames();
        Object[] args = holder.getArguments();
        for (int i = 0; i < args.length; ++i) {
            String name = names[i];
            Object val = args[i];
            if (val == null) {
                value.put(name, "null");
                continue;
            }
            if (val instanceof Mono) {
                args[i] = ((Mono)val).doOnNext(param -> value.put(name, param));
                continue;
            }
            if (val instanceof Flux) {
                ArrayList arr = new ArrayList();
                value.put(name, arr);
                args[i] = ((Flux)val).doOnNext(param -> arr.add(param));
                continue;
            }
            value.put(name, val);
        }
        info.setParameters(value);
        info.setTarget(holder.getTarget().getClass());
        info.setMethod(holder.getMethod());
        return info;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean matches(@Nonnull Method method, @Nonnull Class<?> aClass) {
        if (!Publisher.class.isAssignableFrom(method.getReturnType())) {
            return false;
        }
        AccessLogger ann = (AccessLogger)AnnotationUtils.findAnnotation((Method)method, AccessLogger.class);
        if (ann != null && ann.ignore()) {
            return false;
        }
        return this.loggerParsers.stream().anyMatch(parser -> parser.support(aClass, method));
    }

    @Nonnull
    public Mono<Void> filter(@Nonnull ServerWebExchange exchange, @Nonnull WebFilterChain chain) {
        return chain.filter(exchange).contextWrite((ContextView)Context.of(RequestInfo.class, (Object)this.createAccessInfo(exchange)));
    }

    private RequestInfo createAccessInfo(ServerWebExchange exchange) {
        RequestInfo info = new RequestInfo();
        ServerHttpRequest request = exchange.getRequest();
        info.setRequestId(request.getId());
        info.setPath(request.getPath().value());
        info.setRequestMethod(request.getMethodValue());
        info.setHeaders(request.getHeaders().toSingleValueMap());
        Optional.ofNullable(ReactiveWebUtils.getIpAddr((ServerHttpRequest)request)).ifPresent(arg_0 -> ((RequestInfo)info).setIpAddr(arg_0));
        return info;
    }

    private static class CacheKey {
        private Class<?> type;
        private Method method;

        public CacheKey(Class<?> type, Method method) {
            this.type = type;
            this.method = method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$type = this.type;
            Class<?> other$type = other.type;
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Method this$method = this.method;
            Method other$method = other.method;
            return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.type;
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Method $method = this.method;
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            return result;
        }
    }
}

