/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.logging.aop;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hswebframework.web.aop.MethodInterceptorHolder;
import org.hswebframework.web.logging.AccessLogger;
import org.hswebframework.web.logging.LoggerDefine;
import org.hswebframework.web.logging.aop.AccessLoggerParser;
import org.springframework.core.annotation.AnnotationUtils;

public class DefaultAccessLoggerParser
implements AccessLoggerParser {
    @Override
    public boolean support(Class<?> clazz, Method method) {
        AccessLogger ann = (AccessLogger)AnnotationUtils.findAnnotation((Method)method, AccessLogger.class);
        return null != ann && !ann.ignore();
    }

    @Override
    public LoggerDefine parse(MethodInterceptorHolder holder) {
        AccessLogger methodAnn = (AccessLogger)holder.findMethodAnnotation(AccessLogger.class);
        AccessLogger classAnn = (AccessLogger)holder.findClassAnnotation(AccessLogger.class);
        String action = Stream.of(classAnn, methodAnn).filter(Objects::nonNull).map(AccessLogger::value).reduce((c, m) -> c.concat("-").concat((String)m)).orElse("");
        String describe = Stream.of(classAnn, methodAnn).filter(Objects::nonNull).map(AccessLogger::describe).flatMap(Stream::of).reduce((c, s) -> c.concat("\n").concat((String)s)).orElse("");
        return new LoggerDefine(action, describe);
    }

    @Override
    public Predicate<String> ignoreParameter(MethodInterceptorHolder holder) {
        AccessLogger methodAnn = (AccessLogger)holder.findMethodAnnotation(AccessLogger.class);
        AccessLogger classAnn = (AccessLogger)holder.findClassAnnotation(AccessLogger.class);
        HashSet<String> ignoreParameter = new HashSet<String>();
        if (methodAnn != null) {
            ignoreParameter.addAll(Arrays.asList(methodAnn.ignoreParameter()));
        }
        if (classAnn != null) {
            ignoreParameter.addAll(Arrays.asList(classAnn.ignoreParameter()));
        }
        return parameter -> ignoreParameter.contains("*") || ignoreParameter.contains(parameter);
    }
}

