/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.loggin.aop;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hswebframework.web.aop.MethodInterceptorHolder;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.logger.ReactiveLogger;
import org.hswebframework.web.loggin.aop.AccessLoggerParser;
import org.hswebframework.web.logging.AccessLoggerInfo;
import org.hswebframework.web.logging.LoggerDefine;
import org.hswebframework.web.logging.RequestInfo;
import org.hswebframework.web.logging.events.AccessLoggerAfterEvent;
import org.hswebframework.web.utils.ReactiveWebUtils;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.ClassUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class ReactiveAopAccessLoggerSupport
extends StaticMethodMatcherPointcutAdvisor
implements WebFilter {
    @Autowired(required=false)
    private final List<AccessLoggerParser> loggerParsers = new ArrayList<AccessLoggerParser>();
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public ReactiveAopAccessLoggerSupport() {
        this.setAdvice((Advice)((MethodInterceptor)methodInvocation -> {
            MethodInterceptorHolder methodInterceptorHolder = MethodInterceptorHolder.create((MethodInvocation)methodInvocation);
            AccessLoggerInfo info = this.createLogger(methodInterceptorHolder);
            Object response = methodInvocation.proceed();
            if (response instanceof Mono) {
                return this.wrapMonoResponse((Mono)response, info);
            }
            if (response instanceof Flux) {
                return this.wrapFluxResponse((Flux)response, info);
            }
            return response;
        }));
    }

    protected Flux<?> wrapFluxResponse(Flux<?> flux, AccessLoggerInfo loggerInfo) {
        return Mono.subscriberContext().flatMap(ctx -> Mono.justOrEmpty((Optional)ctx.getOrEmpty(RequestInfo.class)).doOnNext(info -> ReactiveLogger.log((Context)ctx, arg_0 -> ((RequestInfo)info).setContext(arg_0)))).doOnNext(arg_0 -> ((AccessLoggerInfo)loggerInfo).putAccessInfo(arg_0)).thenMany(flux).doOnError(arg_0 -> ((AccessLoggerInfo)loggerInfo).setException(arg_0)).doFinally(f -> {
            loggerInfo.setResponseTime(System.currentTimeMillis());
            this.eventPublisher.publishEvent((Object)new AccessLoggerAfterEvent(loggerInfo));
        }).subscriberContext(ReactiveLogger.start((String)"accessLogId", (String)loggerInfo.getId()));
    }

    protected Mono<?> wrapMonoResponse(Mono<?> mono, AccessLoggerInfo loggerInfo) {
        return Mono.subscriberContext().flatMap(ctx -> Mono.justOrEmpty((Optional)ctx.getOrEmpty(RequestInfo.class)).doOnNext(info -> ReactiveLogger.log((Context)ctx, arg_0 -> ((RequestInfo)info).setContext(arg_0)))).doOnNext(arg_0 -> ((AccessLoggerInfo)loggerInfo).putAccessInfo(arg_0)).then(mono).doOnError(arg_0 -> ((AccessLoggerInfo)loggerInfo).setException(arg_0)).doOnSuccess(arg_0 -> ((AccessLoggerInfo)loggerInfo).setResponse(arg_0)).doFinally(f -> {
            loggerInfo.setResponseTime(System.currentTimeMillis());
            this.eventPublisher.publishEvent((Object)new AccessLoggerAfterEvent(loggerInfo));
        }).subscriberContext(ReactiveLogger.start((String)"accessLogId", (String)loggerInfo.getId()));
    }

    protected AccessLoggerInfo createLogger(MethodInterceptorHolder holder) {
        AccessLoggerInfo info = new AccessLoggerInfo();
        info.setId((String)IDGenerator.MD5.generate());
        info.setRequestTime(System.currentTimeMillis());
        LoggerDefine define = this.loggerParsers.stream().filter(parser -> parser.support(ClassUtils.getUserClass((Object)holder.getTarget()), holder.getMethod())).findAny().map(parser -> parser.parse(holder)).orElse(null);
        if (define != null) {
            info.setAction(define.getAction());
            info.setDescribe(define.getDescribe());
        }
        ConcurrentHashMap<String, Object> value = new ConcurrentHashMap<String, Object>();
        String[] names = holder.getArgumentsNames();
        Object[] args = holder.getArguments();
        for (int i = 0; i < args.length; ++i) {
            String name = names[i];
            Object val = args[i];
            if (val == null) {
                value.put(name, "null");
                continue;
            }
            if (val instanceof Mono) {
                args[i] = ((Mono)val).doOnNext(param -> value.put(name, param));
                continue;
            }
            if (val instanceof Flux) {
                ArrayList arr = new ArrayList();
                value.put(name, arr);
                args[i] = ((Flux)val).doOnNext(param -> arr.add(param));
                continue;
            }
            value.put(name, val);
        }
        info.setParameters(value);
        info.setTarget(holder.getTarget().getClass());
        info.setMethod(holder.getMethod());
        return info;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean matches(Method method, Class<?> aClass) {
        return this.loggerParsers.stream().anyMatch(parser -> parser.support(aClass, method));
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return chain.filter(exchange).subscriberContext(Context.of(RequestInfo.class, (Object)this.createAccessInfo(exchange)));
    }

    private RequestInfo createAccessInfo(ServerWebExchange exchange) {
        RequestInfo info = new RequestInfo();
        ServerHttpRequest request = exchange.getRequest();
        info.setRequestId(request.getId());
        info.setPath(request.getPath().value());
        info.setRequestMethod(request.getMethodValue());
        info.setHeaders(request.getHeaders().toSingleValueMap());
        Optional.ofNullable(ReactiveWebUtils.getIpAddr((ServerHttpRequest)request)).ifPresent(arg_0 -> ((RequestInfo)info).setIpAddr(arg_0));
        return info;
    }
}

