/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.logging;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import org.hswebframework.web.logging.RequestInfo;

public class AccessLoggerInfo {
    private String id;
    private String action;
    private String describe;
    private Method method;
    private Class<?> target;
    private Map<String, Object> parameters;
    private String ip;
    private String url;
    private Map<String, String> httpHeaders;
    private Map<String, String> context;
    private String httpMethod;
    private Object response;
    private long requestTime;
    private long responseTime;
    private Throwable exception;

    public Map<String, Object> toSimpleMap(Function<Object, Serializable> objectFilter, Map<String, Object> map) {
        map.put("action", this.action);
        map.put("describe", this.describe);
        if (this.method != null) {
            StringJoiner methodAppender = new StringJoiner(",", this.method.getName().concat("("), ")");
            String[] parameterNames = this.parameters.keySet().toArray(new String[0]);
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                methodAppender.add(parameterTypes[i].getSimpleName().concat(" ").concat(parameterNames.length > i ? parameterNames[i] : "arg" + i));
            }
            map.put("method", methodAppender.toString());
        }
        map.put("target", this.target != null ? this.target.getName() : "");
        LinkedHashMap<String, Object> newParameter = new LinkedHashMap<String, Object>(this.parameters);
        newParameter.entrySet().forEach(entry -> {
            if (entry.getValue() != null) {
                entry.setValue(objectFilter.apply(entry.getValue()));
            }
        });
        map.put("parameters", newParameter);
        map.put("httpHeaders", this.httpHeaders);
        map.put("httpMethod", this.httpMethod);
        map.put("ip", this.ip);
        map.put("url", this.url);
        map.put("response", objectFilter.apply(this.response));
        map.put("requestTime", this.requestTime);
        map.put("responseTime", this.responseTime);
        map.put("id", this.id);
        map.put("useTime", this.responseTime - this.requestTime);
        if (this.exception != null) {
            StringWriter writer = new StringWriter();
            this.exception.printStackTrace(new PrintWriter(writer));
            map.put("exception", writer.toString());
        }
        return map;
    }

    public void putAccessInfo(RequestInfo info) {
        this.setIp(info.getIpAddr());
        this.setHttpMethod(info.getRequestMethod());
        this.setHttpHeaders(info.getHeaders());
        this.setUrl(info.getPath());
        this.setContext(info.getContext());
    }

    public void putContext(Map<String, String> context) {
        if (this.context == null) {
            this.context = new HashMap<String, String>();
        }
        this.context.putAll(context);
    }

    public void putContext(String key, Object value) {
        if (this.context == null) {
            this.context = new HashMap<String, String>();
        }
        this.context.put(key, String.valueOf(value));
    }

    public String getId() {
        return this.id;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescribe() {
        return this.describe;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getTarget() {
        return this.target;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public Object getResponse() {
        return this.response;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setTarget(Class<?> target) {
        this.target = target;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }
}

