/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.api.crud.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hswebframework.utils.RandomUtil;
import org.hswebframework.web.api.crud.entity.Entity;
import org.hswebframework.web.api.crud.entity.SortSupportEntity;
import org.hswebframework.web.api.crud.entity.TreeUtils;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.id.IDGenerator;
import org.springframework.util.CollectionUtils;

public interface TreeSupportEntity<PK>
extends Entity {
    public PK getId();

    public void setId(PK var1);

    public String getPath();

    public void setPath(String var1);

    public PK getParentId();

    public void setParentId(PK var1);

    public Integer getLevel();

    public void setLevel(Integer var1);

    public <T extends TreeSupportEntity<PK>> List<T> getChildren();

    @Override
    default public void tryValidate(Class<?> ... groups) {
        Entity.super.tryValidate(groups);
        if (this.getId() != null && Objects.equals(this.getId(), this.getParentId())) {
            throw new ValidationException("parentId", "\u5b50\u8282\u70b9ID\u4e0d\u80fd\u4e0e\u7236\u8282\u70b9ID\u76f8\u540c", new Object[0]);
        }
    }

    public static String getParentPath(String path) {
        if (path == null || path.length() < 4) {
            return null;
        }
        return path.substring(0, path.length() - 5);
    }

    public static <T extends TreeSupportEntity> void forEach(Collection<T> list, Consumer<T> consumer) {
        LinkedList<T> queue = new LinkedList<T>(list);
        HashSet<Long> all = new HashSet<Long>();
        TreeSupportEntity node = (TreeSupportEntity)queue.poll();
        while (node != null) {
            long hash = System.identityHashCode(node);
            if (!all.contains(hash)) {
                all.add(hash);
                consumer.accept(node);
                if (!CollectionUtils.isEmpty(node.getChildren())) {
                    queue.addAll(node.getChildren());
                }
            }
            node = (TreeSupportEntity)queue.poll();
        }
    }

    public static <T extends TreeSupportEntity<PK>, PK> List<T> expandTree2List(T parent, IDGenerator<PK> idGenerator) {
        LinkedList list = new LinkedList();
        TreeSupportEntity.expandTree2List(parent, list, idGenerator);
        return list;
    }

    public static <T extends TreeSupportEntity<PK>, PK> void expandTree2List(T parent, List<T> target, IDGenerator<PK> idGenerator) {
        TreeSupportEntity.expandTree2List(parent, target, idGenerator, null);
    }

    public static <T extends TreeSupportEntity<PK>, PK> void expandTree2List(T root, List<T> target, IDGenerator<PK> idGenerator, BiConsumer<T, List<T>> childConsumer) {
        SortSupportEntity sortableRoot;
        Long index;
        if (root.getPath() == null) {
            root.setPath(RandomUtil.randomChar((int)4));
        }
        if (root.getPath() != null) {
            root.setLevel(root.getPath().split("[-]").length);
        }
        if (root instanceof SortSupportEntity && null == (index = (sortableRoot = (SortSupportEntity)((Object)root)).getSortIndex())) {
            sortableRoot.setSortIndex(1L);
        }
        if (CollectionUtils.isEmpty(root.getChildren())) {
            target.add(root);
            return;
        }
        Object parentId = root.getId();
        if (parentId == null) {
            parentId = idGenerator.generate();
            root.setId(parentId);
        }
        LinkedList<TreeSupportEntity> queue = new LinkedList<TreeSupportEntity>();
        queue.add(root);
        HashSet<Long> filter = new HashSet<Long>();
        TreeSupportEntity parent = (TreeSupportEntity)queue.poll();
        while (parent != null) {
            long hash = System.identityHashCode(parent);
            if (!filter.contains(hash)) {
                filter.add(hash);
                if (!CollectionUtils.isEmpty(parent.getChildren())) {
                    long index2 = 1L;
                    for (TreeSupportEntity child : parent.getChildren()) {
                        if (child.getId() == null) {
                            child.setId(idGenerator.generate());
                        }
                        child.setParentId(parent.getId());
                        child.setPath(parent.getPath() + "-" + RandomUtil.randomChar((int)4));
                        child.setLevel(child.getPath().split("[-]").length);
                        if (child instanceof SortSupportEntity && parent instanceof SortSupportEntity) {
                            SortSupportEntity sortableParent = (SortSupportEntity)((Object)parent);
                            SortSupportEntity sortableChild = (SortSupportEntity)((Object)child);
                            sortableChild.setSortIndex(sortableParent.getSortIndex() * 100L + index2++);
                        }
                        queue.add(child);
                    }
                }
                if (childConsumer != null) {
                    childConsumer.accept(parent, new ArrayList());
                }
                target.add(parent);
            }
            parent = (TreeSupportEntity)queue.poll();
        }
    }

    public static <N extends TreeSupportEntity<PK>, PK> List<N> list2tree(Collection<N> dataList, BiConsumer<N, List<N>> childConsumer) {
        return TreeSupportEntity.list2tree(dataList, childConsumer, (TreeHelper<N, PK> predicate) -> node -> node == null || predicate.getNode(node.getParentId()) == null);
    }

    public static <N extends TreeSupportEntity<PK>, PK> List<N> list2tree(Collection<N> dataList, BiConsumer<N, List<N>> childConsumer, Predicate<N> rootNodePredicate) {
        return TreeSupportEntity.list2tree(dataList, childConsumer, (TreeHelper<N, PK> predicate) -> rootNodePredicate);
    }

    public static <N extends TreeSupportEntity<PK>, PK> List<N> list2tree(Collection<N> dataList, BiConsumer<N, List<N>> childConsumer, Function<TreeHelper<N, PK>, Predicate<N>> predicateFunction) {
        return TreeUtils.list2tree(dataList, TreeSupportEntity::getId, TreeSupportEntity::getParentId, childConsumer, (helper, node) -> ((Predicate)predicateFunction.apply((TreeHelper)helper)).test(node));
    }

    public static interface TreeHelper<T, PK> {
        public List<T> getChildren(PK var1);

        public T getNode(PK var1);
    }
}

