/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.api.crud.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.springframework.util.ObjectUtils;

public class TreeUtils {
    public static <N> List<N> treeToList(Collection<N> nodeList, Function<N, Collection<N>> children) {
        ArrayList list = new ArrayList(nodeList.size());
        TreeUtils.flatTree(nodeList, children, list::add);
        return list;
    }

    public static <N> void flatTree(Collection<N> nodeList, Function<N, Collection<N>> children, Consumer<N> handler) {
        LinkedList<N> queue = new LinkedList<N>(nodeList);
        HashSet distinct = new HashSet();
        while (!queue.isEmpty()) {
            Object node = queue.poll();
            if (!distinct.add(node)) continue;
            Collection<N> childrenList = children.apply(node);
            if (CollectionUtils.isNotEmpty(childrenList)) {
                queue.addAll(childrenList);
            }
            handler.accept(node);
        }
    }

    public static <N, PK> List<N> list2tree(Collection<N> dataList, Function<N, PK> idGetter, Function<N, PK> parentIdGetter, BiConsumer<N, List<N>> childConsumer) {
        return TreeUtils.list2tree(dataList, idGetter, parentIdGetter, childConsumer, (helper, node) -> {
            Object parentId = parentIdGetter.apply(node);
            return ObjectUtils.isEmpty(parentId) || helper.getNode(parentId) == null;
        });
    }

    public static <N, PK> List<N> list2tree(Collection<N> dataList, Function<N, PK> idGetter, Function<N, PK> parentIdGetter, BiConsumer<N, List<N>> childConsumer, BiPredicate<TreeSupportEntity.TreeHelper<N, PK>, N> predicateFunction) {
        Objects.requireNonNull(dataList, "source list can not be null");
        Objects.requireNonNull(childConsumer, "child consumer can not be null");
        Objects.requireNonNull(predicateFunction, "root predicate function can not be null");
        final HashMap cache = Maps.newHashMapWithExpectedSize((int)dataList.size());
        final Map treeCache = dataList.stream().peek(node -> cache.put(idGetter.apply(node), node)).filter(e -> parentIdGetter.apply(e) != null).collect(Collectors.groupingBy(parentIdGetter));
        TreeSupportEntity.TreeHelper helper = new TreeSupportEntity.TreeHelper<N, PK>(){

            @Override
            public List<N> getChildren(PK parentId) {
                return (List)treeCache.get(parentId);
            }

            @Override
            public N getNode(PK id) {
                return cache.get(id);
            }
        };
        return dataList.stream().peek(node -> childConsumer.accept((Object)node, (List)treeCache.get(idGetter.apply(node)))).filter(node -> predicateFunction.test(helper, node)).collect(Collectors.toList());
    }
}

