/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.api.crud.entity;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.Param;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.api.crud.entity.TermExpressionParser;
import org.hswebframework.web.bean.FastBeanCopier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QueryParamEntity
extends QueryParam {
    private static final Logger log = LoggerFactory.getLogger(QueryParamEntity.class);
    private static final long serialVersionUID = 8097500947924037523L;
    @Schema(description="where\u6761\u4ef6\u8868\u8fbe\u5f0f,\u4e0eterms\u53c2\u6570\u4e0d\u80fd\u5171\u5b58.\u8bed\u6cd5: name = \u5f20\u4e09 and age > 16")
    private String where;
    @Schema(description="orderBy\u6761\u4ef6\u8868\u8fbe\u5f0f,\u4e0esorts\u53c2\u6570\u4e0d\u80fd\u5171\u5b58.\u8bed\u6cd5: age asc,createTime desc")
    private String orderBy;
    @Schema(description="\u8bbe\u7f6e\u4e86\u6b64\u503c\u540e\u5c06\u4e0d\u91cd\u590d\u6267\u884ccount\u67e5\u8be2\u603b\u6570")
    private Integer total;
    @Schema(description="\u4f7f\u7528map\u65b9\u5f0f\u4f20\u9012\u67e5\u8be2\u6761\u4ef6.\u4e0eterms\u53c2\u6570\u4e0d\u80fd\u5171\u5b58.\u683c\u5f0f: {\"name$like\":\"\u5f20\u4e09\"}")
    private Map<String, Object> filter;
    @Schema(description="\u662f\u5426\u8fdb\u884c\u5e76\u884c\u5206\u9875")
    private boolean parallelPager = false;

    @Hidden
    public boolean isForUpdate() {
        return super.isForUpdate();
    }

    @Hidden
    public int getThinkPageIndex() {
        return super.getThinkPageIndex();
    }

    @Hidden
    public int getPageIndexTmp() {
        return super.getPageIndexTmp();
    }

    @Schema(description="\u6307\u5b9a\u8981\u67e5\u8be2\u7684\u5217")
    @Nonnull
    public Set<String> getIncludes() {
        return super.getIncludes();
    }

    @Schema(description="\u6307\u5b9a\u4e0d\u67e5\u8be2\u7684\u5217")
    @Nonnull
    public Set<String> getExcludes() {
        return super.getExcludes();
    }

    public static QueryParamEntity of(Param param) {
        if (param instanceof QueryParamEntity) {
            return ((QueryParamEntity)param).clone();
        }
        return (QueryParamEntity)((Object)FastBeanCopier.copy((Object)param, (Object)((Object)new QueryParamEntity()), (String[])new String[0]));
    }

    public static QueryParamEntity of() {
        return new QueryParamEntity();
    }

    public static QueryParamEntity of(String field, Object value) {
        return (QueryParamEntity)QueryParamEntity.of().and(field, "eq", value);
    }

    public static <T> Query<T, QueryParamEntity> newQuery() {
        return Query.of((QueryParam)new QueryParamEntity());
    }

    public <T> Query<T, QueryParamEntity> toQuery() {
        return Query.of((QueryParam)this);
    }

    public <T> Query<T, QueryParamEntity> toNestQuery() {
        return this.toNestQuery(null);
    }

    public <T> Query<T, QueryParamEntity> toNestQuery(Consumer<Query<T, QueryParamEntity>> before) {
        List<Term> terms = this.getTerms();
        this.setTerms(new ArrayList());
        Query<T, QueryParamEntity> query = this.toQuery();
        if (null != before) {
            before.accept(query);
        }
        if (terms.isEmpty()) {
            return query;
        }
        return (Query)((NestConditional)query.nest().each(terms, NestConditional::accept)).end();
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        if (!StringUtils.hasText((String)orderBy)) {
            return;
        }
        this.setSorts(TermExpressionParser.parseOrder(orderBy));
    }

    public void setWhere(String where) {
        this.where = where;
        if (!StringUtils.hasText((String)where)) {
            return;
        }
        this.setTerms(TermExpressionParser.parse(where));
    }

    public void setFilter(Map<String, Object> filter) {
        this.filter = filter;
        if (MapUtils.isNotEmpty(filter)) {
            this.setTerms(TermExpressionParser.parse(filter));
        }
    }

    @Nonnull
    public List<Term> getTerms() {
        List<Term> terms = super.getTerms();
        if (CollectionUtils.isEmpty((Collection)terms) && StringUtils.hasText((String)this.where)) {
            terms = TermExpressionParser.parse(this.where);
            this.setTerms(terms);
        }
        if (CollectionUtils.isEmpty((Collection)terms) && MapUtils.isNotEmpty(this.filter)) {
            terms = TermExpressionParser.parse(this.filter);
            this.setTerms(terms);
        }
        return terms;
    }

    public QueryParamEntity noPaging() {
        this.setPaging(false);
        return this;
    }

    public QueryParamEntity doNotSort() {
        this.setSorts(new ArrayList());
        return this;
    }

    public QueryParamEntity clone() {
        return (QueryParamEntity)super.clone();
    }

    public String getWhere() {
        return this.where;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Integer getTotal() {
        return this.total;
    }

    public boolean isParallelPager() {
        return this.parallelPager;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Map<String, Object> getFilter() {
        return this.filter;
    }

    public void setParallelPager(boolean parallelPager) {
        this.parallelPager = parallelPager;
    }
}

