/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.commons.bean;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hswebframework.web.validate.SimpleValidateResults;
import org.hswebframework.web.validate.ValidateResults;
import org.hswebframework.web.validate.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanValidator {
    private static final Logger log = LoggerFactory.getLogger(BeanValidator.class);
    static volatile Validator validator;

    private BeanValidator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Validator getValidator() {
        if (validator == null) {
            Class<BeanValidator> clazz = BeanValidator.class;
            synchronized (BeanValidator.class) {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                validator = factory.getValidator();
                // ** MonitorExit[var0] (shouldn't be in output)
                return validator;
            }
        }
        return validator;
    }

    public static <T> T tryValidate(T bean, Class ... group) {
        Set violations = BeanValidator.getValidator().validate(bean, group);
        if (!violations.isEmpty()) {
            SimpleValidateResults results = new SimpleValidateResults();
            for (ConstraintViolation violation : violations) {
                results.addResult(violation.getPropertyPath().toString(), violation.getMessage());
            }
            throw new ValidationException((ValidateResults)results);
        }
        return bean;
    }
}

