/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.configuration;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.defaults.DefaultSyncRepository;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.ImplementFor;
import org.hswebframework.web.crud.annotation.EnableEasyormRepository;
import org.hswebframework.web.crud.annotation.Reactive;
import org.hswebframework.web.crud.configuration.AutoDDLProcessor;
import org.hswebframework.web.crud.configuration.EntityInfo;
import org.hswebframework.web.crud.configuration.ReactiveRepositoryFactoryBean;
import org.hswebframework.web.crud.configuration.SyncRepositoryFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class EasyormRepositoryRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(EasyormRepositoryRegistrar.class);
    private final ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private final MetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory();

    private Stream<Resource> doGetResources(String packageStr) {
        String path = "classpath*:".concat(packageStr.replace(".", "/")).concat("/**/*.class");
        return Arrays.stream(this.resourcePatternResolver.getResources(path));
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map attr = importingClassMetadata.getAnnotationAttributes(EnableEasyormRepository.class.getName());
        if (attr == null) {
            return;
        }
        boolean reactivePrecent = ClassUtils.isPresent((String)"io.r2dbc.spi.ConnectionFactory", (ClassLoader)this.getClass().getClassLoader());
        String[] arr = (String[])attr.get("value");
        Set resources = Arrays.stream(arr).flatMap(this::doGetResources).collect(Collectors.toSet());
        Class[] anno = (Class[])attr.get("annotation");
        HashSet<EntityInfo> entityInfos = new HashSet<EntityInfo>();
        for (Object resource : resources) {
            EntityInfo entityInfo;
            MetadataReader reader = this.metadataReaderFactory.getMetadataReader((Resource)resource);
            String className = reader.getClassMetadata().getClassName();
            Class entityType = ClassUtils.forName((String)className, null);
            if (Arrays.stream(anno).noneMatch(ann -> AnnotationUtils.findAnnotation((Class)entityType, (Class)ann) != null)) continue;
            ImplementFor implementFor = (ImplementFor)AnnotationUtils.findAnnotation((Class)entityType, ImplementFor.class);
            Reactive reactive = (Reactive)AnnotationUtils.findAnnotation((Class)entityType, Reactive.class);
            Class genericType = Optional.ofNullable(implementFor).map(ImplementFor::value).orElseGet(() -> Stream.of(entityType.getInterfaces()).filter(e -> GenericEntity.class.isAssignableFrom((Class<?>)e)).findFirst().orElse(entityType));
            Class<?> idType = null;
            if (implementFor == null || implementFor.idType() == Void.class) {
                try {
                    if (GenericEntity.class.isAssignableFrom(entityType)) {
                        idType = org.hswebframework.utils.ClassUtils.getGenericType((Class)entityType);
                    }
                    if (idType == null) {
                        Method getId = ClassUtils.getMethod((Class)entityType, (String)"getId", (Class[])new Class[0]);
                        idType = getId.getReturnType();
                    }
                }
                catch (Exception e) {
                    idType = String.class;
                }
            } else {
                idType = implementFor.idType();
            }
            if (entityInfos.contains(entityInfo = new EntityInfo(genericType, entityType, idType, reactivePrecent && (reactive == null || reactive.enable()))) && implementFor == null) continue;
            entityInfos.add(entityInfo);
        }
        boolean reactive = false;
        for (EntityInfo entityInfo : entityInfos) {
            RootBeanDefinition definition;
            ResolvableType repositoryType;
            Class entityType = entityInfo.getEntityType();
            Class idType = entityInfo.getIdType();
            Class realType = entityInfo.getRealType();
            if (entityInfo.isReactive()) {
                reactive = true;
                log.trace("register ReactiveRepository<{},{}>", (Object)entityType.getName(), (Object)idType.getSimpleName());
                repositoryType = ResolvableType.forClassWithGenerics(DefaultReactiveRepository.class, (Class[])new Class[]{entityType, idType});
                definition = new RootBeanDefinition();
                definition.setTargetType(repositoryType);
                definition.setBeanClass(ReactiveRepositoryFactoryBean.class);
                definition.setAutowireMode(2);
                definition.getPropertyValues().add("entityType", (Object)realType);
                registry.registerBeanDefinition(realType.getSimpleName().concat("ReactiveRepository"), (BeanDefinition)definition);
                continue;
            }
            log.trace("register SyncRepository<{},{}>", (Object)entityType.getName(), (Object)idType.getSimpleName());
            repositoryType = ResolvableType.forClassWithGenerics(DefaultSyncRepository.class, (Class[])new Class[]{entityType, idType});
            definition = new RootBeanDefinition();
            definition.setTargetType(repositoryType);
            definition.setBeanClass(SyncRepositoryFactoryBean.class);
            definition.setAutowireMode(2);
            definition.getPropertyValues().add("entityType", (Object)realType);
            registry.registerBeanDefinition(realType.getSimpleName().concat("SyncRepository"), (BeanDefinition)definition);
        }
        try {
            BeanDefinition definition = registry.getBeanDefinition(AutoDDLProcessor.class.getName());
            Set infos = (Set)definition.getPropertyValues().get("entities");
            infos.addAll(entityInfos);
        }
        catch (NoSuchBeanDefinitionException e) {
            RootBeanDefinition definition = new RootBeanDefinition();
            definition.setTargetType(AutoDDLProcessor.class);
            definition.setBeanClass(AutoDDLProcessor.class);
            definition.setAutowireMode(2);
            definition.getPropertyValues().add("entities", entityInfos);
            definition.getPropertyValues().add("reactive", (Object)reactive);
            registry.registerBeanDefinition(AutoDDLProcessor.class.getName(), (BeanDefinition)definition);
        }
    }
}

