/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.events;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.web.api.crud.entity.Entity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.crud.events.EntityEventListenerConfigure;
import org.hswebframework.web.crud.events.EntityEventPhase;
import org.hswebframework.web.crud.events.EntityEventType;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class DefaultEntityEventListenerConfigure
implements EntityEventListenerConfigure {
    private final Map<Class<? extends Entity>, Map<EntityEventType, Set<EntityEventPhase>>> enabledFeatures = new ConcurrentHashMap<Class<? extends Entity>, Map<EntityEventType, Set<EntityEventPhase>>>();
    private final Map<Class<? extends Entity>, Map<EntityEventType, Set<EntityEventPhase>>> disabledFeatures = new ConcurrentHashMap<Class<? extends Entity>, Map<EntityEventType, Set<EntityEventPhase>>>();

    @Override
    public void enable(Class<? extends Entity> entityType) {
        this.initByEntity(entityType, this.getOrCreateTypeMap(entityType, this.enabledFeatures), true);
    }

    @Override
    public void disable(Class<? extends Entity> entityType) {
        this.enabledFeatures.remove(entityType);
        this.initByEntity(entityType, this.getOrCreateTypeMap(entityType, this.disabledFeatures), true);
    }

    @Override
    public void enable(Class<? extends Entity> entityType, EntityEventType type, EntityEventPhase ... feature) {
        if (feature.length == 0) {
            feature = EntityEventPhase.all;
        }
        this.getOrCreatePhaseSet(type, this.getOrCreateTypeMap(entityType, this.enabledFeatures)).addAll(Arrays.asList(feature));
        Arrays.asList(feature).forEach(this.getOrCreatePhaseSet(type, this.getOrCreateTypeMap(entityType, this.disabledFeatures))::remove);
    }

    @Override
    public void disable(Class<? extends Entity> entityType, EntityEventType type, EntityEventPhase ... feature) {
        if (feature.length == 0) {
            feature = EntityEventPhase.all;
        }
        this.getOrCreatePhaseSet(type, this.getOrCreateTypeMap(entityType, this.disabledFeatures)).addAll(Arrays.asList(feature));
        Arrays.asList(feature).forEach(this.getOrCreatePhaseSet(type, this.getOrCreateTypeMap(entityType, this.enabledFeatures))::remove);
    }

    protected Map<EntityEventType, Set<EntityEventPhase>> getOrCreateTypeMap(Class<? extends Entity> type, Map<Class<? extends Entity>, Map<EntityEventType, Set<EntityEventPhase>>> map) {
        return map.computeIfAbsent(type, ignore -> new EnumMap(EntityEventType.class));
    }

    protected Set<EntityEventPhase> getOrCreatePhaseSet(EntityEventType type, Map<EntityEventType, Set<EntityEventPhase>> map) {
        return map.computeIfAbsent(type, ignore -> EnumSet.noneOf(EntityEventPhase.class));
    }

    protected void initByEntity(Class<? extends Entity> type, Map<EntityEventType, Set<EntityEventPhase>> typeSetMap, boolean all) {
        EntityEventType[] types;
        EnableEntityEvent annotation = (EnableEntityEvent)AnnotatedElementUtils.findMergedAnnotation(type, EnableEntityEvent.class);
        for (EntityEventType entityEventType : types = annotation != null ? annotation.value() : (all ? EntityEventType.values() : new EntityEventType[]{})) {
            Set<EntityEventPhase> phases = this.getOrCreatePhaseSet(entityEventType, typeSetMap);
            phases.addAll(Arrays.asList(EntityEventPhase.values()));
        }
    }

    @Override
    public boolean isEnabled(Class<? extends Entity> entityType) {
        if (!this.enabledFeatures.containsKey(entityType)) {
            this.initByEntity(entityType, this.getOrCreateTypeMap(entityType, this.enabledFeatures), false);
        }
        return MapUtils.isNotEmpty(this.enabledFeatures.get(entityType));
    }

    @Override
    public boolean isEnabled(Class<? extends Entity> entityType, EntityEventType type, EntityEventPhase phase) {
        Map<EntityEventType, Set<EntityEventPhase>> enabled;
        if (!this.enabledFeatures.containsKey(entityType)) {
            this.initByEntity(entityType, this.getOrCreateTypeMap(entityType, this.enabledFeatures), false);
        }
        if (MapUtils.isEmpty(enabled = this.enabledFeatures.get(entityType))) {
            return false;
        }
        Map<EntityEventType, Set<EntityEventPhase>> disabled = this.disabledFeatures.get(entityType);
        Set<EntityEventPhase> phases = enabled.get((Object)type);
        if (phases != null && phases.contains((Object)phase)) {
            if (disabled != null) {
                Set<EntityEventPhase> disabledPhases = disabled.get((Object)type);
                return disabledPhases == null || !disabledPhases.contains((Object)phase);
            }
            return true;
        }
        return false;
    }
}

