/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import org.hswebframework.web.crud.web.ResponseMessage;
import org.hswebframework.web.i18n.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import reactor.core.publisher.Mono;

@RestControllerAdvice
public class R2dbcErrorControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(R2dbcErrorControllerAdvice.class);

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(R2dbcDataIntegrityViolationException e) {
        String code;
        if (e.getMessage().contains("Duplicate")) {
            code = "error.duplicate_data";
        } else {
            code = "error.data_error";
            log.warn(e.getMessage(), (Throwable)e);
        }
        return LocaleUtils.resolveMessageReactive((String)code, (Object[])new Object[0]).map(msg -> ResponseMessage.error(400, code, msg));
    }
}

