/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web.reactive;

import io.swagger.v3.oas.annotations.Operation;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveServiceSaveController<E, K> {
    @Authorize(ignore=true)
    public ReactiveCrudService<E, K> getService();

    @Authorize(ignore=true)
    default public E applyCreationEntity(Authentication authentication, E entity) {
        RecordCreationEntity creationEntity = (RecordCreationEntity)entity;
        creationEntity.setCreateTimeNow();
        creationEntity.setCreatorId(authentication.getUser().getId());
        creationEntity.setCreatorName(authentication.getUser().getName());
        return entity;
    }

    @Authorize(ignore=true)
    default public E applyModifierEntity(Authentication authentication, E entity) {
        RecordModifierEntity modifierEntity = (RecordModifierEntity)entity;
        modifierEntity.setModifyTimeNow();
        modifierEntity.setModifierId(authentication.getUser().getId());
        modifierEntity.setModifierName(authentication.getUser().getName());
        return entity;
    }

    @Authorize(ignore=true)
    default public E applyAuthentication(E entity, Authentication authentication) {
        if (entity instanceof RecordCreationEntity) {
            entity = this.applyCreationEntity(authentication, entity);
        }
        if (entity instanceof RecordModifierEntity) {
            entity = this.applyModifierEntity(authentication, entity);
        }
        return entity;
    }

    @PatchMapping
    @SaveAction
    @Operation(summary="\u4fdd\u5b58\u6570\u636e", description="\u5982\u679c\u4f20\u5165\u4e86id,\u5e76\u4e14\u5bf9\u5e94\u6570\u636e\u5b58\u5728,\u5219\u5c1d\u8bd5\u8986\u76d6,\u4e0d\u5b58\u5728\u5219\u65b0\u589e.")
    default public Mono<SaveResult> save(@RequestBody Flux<E> payload) {
        return (Mono)Authentication.currentReactive().flatMapMany(auth -> payload.map(entity -> this.applyAuthentication((E)entity, (Authentication)auth))).switchIfEmpty(payload).as(this.getService()::save);
    }

    @PostMapping(value={"/_batch"})
    @SaveAction
    @Operation(summary="\u6279\u91cf\u65b0\u589e\u6570\u636e")
    default public Mono<Integer> add(@RequestBody Flux<E> payload) {
        return (Mono)Authentication.currentReactive().flatMapMany(auth -> payload.map(entity -> this.applyAuthentication((E)entity, (Authentication)auth))).switchIfEmpty(payload).collectList().as(this.getService()::insertBatch);
    }

    @PostMapping
    @SaveAction
    @Operation(summary="\u65b0\u589e\u5355\u4e2a\u6570\u636e,\u5e76\u8fd4\u56de\u65b0\u589e\u540e\u7684\u6570\u636e.")
    default public Mono<E> add(@RequestBody Mono<E> payload) {
        return Authentication.currentReactive().flatMap(auth -> payload.map(entity -> this.applyAuthentication((E)entity, (Authentication)auth))).switchIfEmpty(payload).flatMap(entity -> this.getService().insert(Mono.just((Object)entity)).thenReturn(entity));
    }

    @PutMapping(value={"/{id}"})
    @SaveAction
    @Operation(summary="\u6839\u636eID\u4fee\u6539\u6570\u636e")
    default public Mono<Boolean> update(@PathVariable K id, @RequestBody Mono<E> payload) {
        return Authentication.currentReactive().flatMap(auth -> payload.map(entity -> this.applyAuthentication((E)entity, (Authentication)auth))).switchIfEmpty(payload).flatMap(entity -> this.getService().updateById((Object)id, Mono.just((Object)entity))).thenReturn((Object)true);
    }
}

