/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.events;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hswebframework.web.api.crud.entity.Entity;
import org.hswebframework.web.crud.events.EntityCreatedEvent;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.event.AsyncEvent;
import org.hswebframework.web.event.GenericsPayloadApplicationEvent;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class EntityEventHelper {
    private static final String doEventContextKey = EntityEventHelper.class.getName() + "_doEvent";

    public static Mono<Boolean> isDoFireEvent(boolean defaultIfEmpty) {
        return Mono.subscriberContext().flatMap(ctx -> Mono.justOrEmpty((Optional)ctx.getOrEmpty((Object)doEventContextKey))).defaultIfEmpty((Object)defaultIfEmpty);
    }

    public static <T> Mono<T> setDoNotFireEvent(Mono<T> stream) {
        return stream.subscriberContext(Context.of((Object)doEventContextKey, (Object)false));
    }

    public static <T> Flux<T> setDoNotFireEvent(Flux<T> stream) {
        return stream.subscriberContext(Context.of((Object)doEventContextKey, (Object)false));
    }

    public static <T> Mono<Void> publishSavedEvent(Object source, Class<T> entityType, List<T> entities, Consumer<GenericsPayloadApplicationEvent<EntitySavedEvent<T>>> publisher) {
        return EntityEventHelper.publishEvent(source, entityType, () -> new EntitySavedEvent(entities, entityType), publisher);
    }

    public static <T extends Entity> Mono<Void> publishModifyEvent(Object source, Class<T> entityType, List<T> before, Consumer<T> afterTransfer, Consumer<GenericsPayloadApplicationEvent<EntityModifyEvent<T>>> publisher) {
        return EntityEventHelper.publishEvent(source, entityType, () -> new EntityModifyEvent(before, before.stream().map(t -> (Entity)t.copyTo(entityType, new String[0])).peek(afterTransfer).collect(Collectors.toList()), entityType), publisher);
    }

    public static <T> Mono<Void> publishModifyEvent(Object source, Class<T> entityType, List<T> before, List<T> after, Consumer<GenericsPayloadApplicationEvent<EntityModifyEvent<T>>> publisher) {
        return EntityEventHelper.publishEvent(source, entityType, () -> new EntityModifyEvent(before, after, entityType), publisher);
    }

    public static <T> Mono<Void> publishDeletedEvent(Object source, Class<T> entityType, List<T> entities, Consumer<GenericsPayloadApplicationEvent<EntityDeletedEvent<T>>> publisher) {
        return EntityEventHelper.publishEvent(source, entityType, () -> new EntityDeletedEvent(entities, entityType), publisher);
    }

    public static <T> Mono<Void> publishCreatedEvent(Object source, Class<T> entityType, List<T> entities, Consumer<GenericsPayloadApplicationEvent<EntityCreatedEvent<T>>> publisher) {
        return EntityEventHelper.publishEvent(source, entityType, () -> new EntityCreatedEvent(entities, entityType), publisher);
    }

    public static <T, E extends AsyncEvent> Mono<Void> publishEvent(Object source, Class<T> entityType, Supplier<E> eventSupplier, Consumer<GenericsPayloadApplicationEvent<E>> publisher) {
        AsyncEvent event = (AsyncEvent)eventSupplier.get();
        if (event == null) {
            return Mono.empty();
        }
        publisher.accept(new GenericsPayloadApplicationEvent(source, (Object)event, new Class[]{entityType}));
        return event.getAsync();
    }
}

