/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.events;

import java.util.Collection;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.events.EventContext;
import org.hswebframework.ezorm.rdb.events.EventListener;
import org.hswebframework.ezorm.rdb.events.EventType;
import org.hswebframework.ezorm.rdb.mapping.events.MappingContextKeys;
import org.hswebframework.ezorm.rdb.mapping.events.MappingEventTypes;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.authorization.Authentication;
import org.springframework.util.ObjectUtils;

public class CreatorEventListener
implements EventListener {
    public String getId() {
        return "creator-listener";
    }

    public String getName() {
        return "\u521b\u5efa\u8005\u76d1\u542c\u5668";
    }

    public void onEvent(EventType type, EventContext context) {
        Optional resultHolder = context.get(MappingContextKeys.reactiveResultHolder);
        if (type == MappingEventTypes.insert_before || type == MappingEventTypes.save_before || type == MappingEventTypes.update_before) {
            if (resultHolder.isPresent()) {
                resultHolder.ifPresent(holder -> holder.before(Authentication.currentReactive().doOnNext(auth -> this.doApplyCreator(type, context, (Authentication)auth)).then()));
            } else {
                Authentication.current().ifPresent(auth -> this.doApplyCreator(type, context, (Authentication)auth));
            }
        }
    }

    protected void doApplyCreator(EventType type, EventContext context, Authentication auth) {
        context.get(MappingContextKeys.instance).ifPresent(obj -> {
            if (obj instanceof Collection) {
                this.applyCreator(auth, (Collection)obj, type != MappingEventTypes.update_before);
            } else {
                this.applyCreator(auth, obj, type != MappingEventTypes.update_before);
            }
        });
    }

    public void applyCreator(Authentication auth, Object entity, boolean updateCreator) {
        RecordCreationEntity e;
        if (updateCreator && entity instanceof RecordCreationEntity) {
            e = (RecordCreationEntity)entity;
            if (ObjectUtils.isEmpty((Object)e.getCreatorId())) {
                e.setCreatorId(auth.getUser().getId());
                e.setCreatorName(auth.getUser().getName());
            }
            if (e.getCreateTime() == null) {
                e.setCreateTimeNow();
            }
        }
        if (entity instanceof RecordModifierEntity) {
            e = (RecordModifierEntity)entity;
            if (ObjectUtils.isEmpty((Object)e.getModifierId())) {
                e.setModifierId(auth.getUser().getId());
                e.setModifierName(auth.getUser().getName());
            }
            if (e.getModifyTime() == null) {
                e.setModifyTimeNow();
            }
        }
    }

    public void applyCreator(Authentication auth, Collection<?> entities, boolean updateCreator) {
        for (Object entity : entities) {
            this.applyCreator(auth, entity, updateCreator);
        }
    }
}

