/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.Collection;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.cache.ReactiveCache;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface EnableCacheReactiveCrudService<E, K>
extends ReactiveCrudService<E, K> {
    public ReactiveCache<E> getCache();

    @Override
    default public Mono<E> findById(K id) {
        return this.getCache().mono((Object)("id:" + id)).onCacheMissResume(ReactiveCrudService.super.findById(Mono.just(id)));
    }

    @Override
    default public Mono<E> findById(Mono<K> publisher) {
        return publisher.flatMap(this::findById);
    }

    @Override
    default public Mono<Integer> updateById(K id, Mono<E> entityPublisher) {
        return ReactiveCrudService.super.updateById(id, entityPublisher).doFinally(i -> this.getCache().evict((Object)("id:" + id)).subscribe());
    }

    @Override
    default public Mono<SaveResult> save(E data) {
        return ReactiveCrudService.super.save(data).doFinally(i -> this.getCache().clear().subscribe());
    }

    @Override
    default public Mono<SaveResult> save(Publisher<E> entityPublisher) {
        return ReactiveCrudService.super.save(entityPublisher).doFinally(i -> this.getCache().clear().subscribe());
    }

    @Override
    default public Mono<Integer> insert(E data) {
        return ReactiveCrudService.super.insert(data).doFinally(i -> this.getCache().clear().subscribe());
    }

    @Override
    default public Mono<Integer> insert(Publisher<E> entityPublisher) {
        return ReactiveCrudService.super.insert(entityPublisher).doFinally(i -> this.getCache().clear().subscribe());
    }

    @Override
    default public Mono<Integer> insertBatch(Publisher<? extends Collection<E>> entityPublisher) {
        return ReactiveCrudService.super.insertBatch(entityPublisher).doFinally(i -> this.getCache().clear().subscribe());
    }

    @Override
    default public Mono<Integer> deleteById(Publisher<K> idPublisher) {
        return (Mono)Flux.from(idPublisher).flatMap(id -> this.getCache().evict((Object)("id:" + id)).thenReturn(id)).as(x$0 -> ReactiveCrudService.super.deleteById(x$0));
    }

    @Override
    default public ReactiveUpdate<E> createUpdate() {
        return ReactiveCrudService.super.createUpdate().onExecute((update, s) -> s.doFinally(__ -> this.getCache().clear().subscribe()));
    }

    @Override
    default public ReactiveDelete createDelete() {
        return ReactiveCrudService.super.createDelete().onExecute((update, s) -> s.doFinally(__ -> this.getCache().clear().subscribe()));
    }
}

