/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.operator.dml.Terms;
import org.hswebframework.utils.RandomUtil;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSortSupportEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.validator.CreateGroup;
import org.reactivestreams.Publisher;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.math.MathFlux;

public interface ReactiveTreeSortEntityService<E extends TreeSortSupportEntity<K>, K>
extends ReactiveCrudService<E, K> {
    default public Mono<List<E>> queryResultToTree(Mono<? extends QueryParamEntity> paramEntity) {
        return paramEntity.flatMap(this::queryResultToTree);
    }

    default public Mono<List<E>> queryResultToTree(QueryParamEntity paramEntity) {
        return this.query(paramEntity).collectList().map(list -> TreeSupportEntity.list2tree((Collection)list, this::setChildren, this::createRootNodePredicate));
    }

    default public Mono<List<E>> queryIncludeChildrenTree(QueryParamEntity paramEntity) {
        return this.queryIncludeChildren(paramEntity).collectList().map(list -> TreeSupportEntity.list2tree((Collection)list, this::setChildren, this::createRootNodePredicate));
    }

    default public Flux<E> queryIncludeChildren(Collection<K> idList) {
        HashSet duplicateCheck = new HashSet();
        return this.findById(idList).concatMap(e -> StringUtils.isEmpty((Object)e.getPath()) || !duplicateCheck.add(e.getPath()) ? Mono.just((Object)e) : ((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).like$("path", (Object)e.getPath())).fetch()).distinct(TreeSupportEntity::getId);
    }

    default public Flux<E> queryIncludeParent(Collection<K> idList) {
        HashSet duplicateCheck = new HashSet();
        return this.findById(idList).concatMap(e -> StringUtils.isEmpty((Object)e.getPath()) || !duplicateCheck.add(e.getPath()) ? Mono.just((Object)e) : ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).accept(Terms.Like.reversal((String)"path", (String)e.getPath(), (boolean)false, (boolean)true))).notEmpty("path")).notNull("path")).fetch()).distinct(TreeSupportEntity::getId);
    }

    default public Flux<E> queryIncludeChildren(QueryParamEntity queryParam) {
        HashSet duplicateCheck = new HashSet();
        return this.query(queryParam).concatMap(e -> StringUtils.isEmpty((Object)e.getPath()) || !duplicateCheck.add(e.getPath()) ? Mono.just((Object)e) : ((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).like$("path", (Object)e.getPath())).fetch()).distinct(TreeSupportEntity::getId);
    }

    @Override
    default public Mono<Integer> insert(Publisher<E> entityPublisher) {
        return this.insertBatch((Publisher<? extends Collection<E>>)Flux.from(entityPublisher).collectList());
    }

    @Override
    default public Mono<Integer> insertBatch(Publisher<? extends Collection<E>> entityPublisher) {
        return this.getRepository().insertBatch((Publisher)Flux.from(entityPublisher).flatMap(Flux::fromIterable).flatMap(this::applyTreeProperty).flatMap(e -> Flux.fromIterable((Iterable)TreeSupportEntity.expandTree2List((TreeSupportEntity)e, this.getIDGenerator()))).collectList());
    }

    default public Mono<E> applyTreeProperty(E ele) {
        if (StringUtils.hasText((String)ele.getPath()) || StringUtils.isEmpty((Object)ele.getParentId())) {
            return Mono.just(ele);
        }
        return this.checkCyclicDependency(ele.getId(), ele).then(this.findById(ele.getParentId()).doOnNext(parent -> ele.setPath(parent.getPath() + "-" + RandomUtil.randomChar((int)4)))).thenReturn(ele);
    }

    default public Mono<E> checkCyclicDependency(K id, E ele) {
        if (StringUtils.isEmpty(id)) {
            return Mono.empty();
        }
        return this.queryIncludeChildren(Collections.singletonList(id)).doOnNext(e -> {
            if (Objects.equals(ele.getParentId(), e.getId())) {
                throw new IllegalArgumentException("\u4e0d\u80fd\u4fee\u6539\u7236\u8282\u70b9\u4e3a\u81ea\u5df1\u6216\u8005\u81ea\u5df1\u7684\u5b50\u8282\u70b9");
            }
        }).then(Mono.just(ele));
    }

    default public Mono<Void> refactorChildPath(K id, String path, Consumer<E> pathAccepter) {
        return ((Mono)((ReactiveQuery)this.createQuery().where("parentId", id)).fetch().flatMap(e -> {
            if (StringUtils.isEmpty((Object)path)) {
                e.setPath(RandomUtil.randomChar((int)4));
            } else {
                e.setPath(path + "-" + RandomUtil.randomChar((int)4));
            }
            pathAccepter.accept(e);
            if (e.getParentId() != null) {
                return this.refactorChildPath(e.getId(), e.getPath(), pathAccepter).thenReturn(e);
            }
            return Mono.just((Object)e);
        }).as(arg_0 -> this.getRepository().save(arg_0))).then();
    }

    @Override
    default public Mono<SaveResult> save(Publisher<E> entityPublisher) {
        return (Mono)((Flux)Flux.from(entityPublisher).flatMapIterable(e -> TreeSupportEntity.expandTree2List((TreeSupportEntity)e, this.getIDGenerator())).collectList().flatMapIterable(list -> {
            Map map = list.stream().filter(e -> e.getId() != null).collect(Collectors.toMap(TreeSupportEntity::getId, Function.identity()));
            return TreeSupportEntity.list2tree((Collection)list, this::setChildren, e -> this.isRootNode(e) || map.get(e.getParentId()) == null);
        }).doOnNext(e -> e.tryValidate(new Class[]{CreateGroup.class})).flatMapIterable(e -> TreeSupportEntity.expandTree2List((TreeSupportEntity)e, this.getIDGenerator())).as(this::tryRefactorPath)).as(arg_0 -> this.getRepository().save(arg_0));
    }

    default public Flux<E> tryRefactorPath(Flux<E> stream) {
        Flux cache = stream.cache();
        Mono mapping = cache.filter(e -> null != e.getId()).collectMap(TreeSupportEntity::getId, Function.identity()).defaultIfEmpty(Collections.emptyMap());
        Mono olds = ((Flux)cache.filter(e -> null != e.getId()).map(TreeSupportEntity::getId).as(this::findById)).collectMap(TreeSupportEntity::getId, Function.identity()).defaultIfEmpty(Collections.emptyMap());
        return Mono.zip((Mono)mapping, (Mono)olds).flatMapMany(tp2 -> {
            Map map = (Map)tp2.getT1();
            Map oldMap = (Map)tp2.getT2();
            return cache.flatMap(data -> {
                TreeSortSupportEntity oldParent;
                TreeSortSupportEntity old = data.getId() == null ? null : (TreeSortSupportEntity)oldMap.get(data.getId());
                Object parentId = old != null ? old.getParentId() : data.getParentId();
                TreeSortSupportEntity treeSortSupportEntity = oldParent = parentId == null ? null : (TreeSortSupportEntity)oldMap.get(parentId);
                if (old != null) {
                    Object newParentId = data.getParentId();
                    if (!Objects.equals(parentId, newParentId)) {
                        ArrayList<Object> jobs = new ArrayList<Object>();
                        Consumer<TreeSortSupportEntity> childConsumer = child -> {
                            TreeSortSupportEntity readyToUpdate = (TreeSortSupportEntity)map.get(child.getId());
                            if (null != readyToUpdate) {
                                readyToUpdate.setPath(child.getPath());
                            }
                        };
                        if (this.isRootNode(data)) {
                            data.setPath(RandomUtil.randomChar((int)4));
                            jobs.add(this.refactorChildPath(old.getId(), data.getPath(), childConsumer));
                        } else if (null != oldParent) {
                            data.setPath(oldParent.getPath() + "-" + RandomUtil.randomChar((int)4));
                            jobs.add(this.refactorChildPath(old.getId(), data.getPath(), childConsumer));
                        } else {
                            jobs.add(this.findById(newParentId).flatMap(parent -> {
                                data.setPath(parent.getPath() + "-" + RandomUtil.randomChar((int)4));
                                return this.refactorChildPath(data.getId(), data.getPath(), childConsumer);
                            }));
                        }
                        return Flux.merge(jobs).then(Mono.just((Object)data));
                    }
                    Consumer<TreeSortSupportEntity> pathRefactor = parent -> {
                        if (old.getPath().startsWith(parent.getPath())) {
                            data.setPath(old.getPath());
                        } else {
                            data.setPath(parent.getPath() + "-" + RandomUtil.randomChar((int)4));
                        }
                    };
                    if (oldParent != null) {
                        pathRefactor.accept(oldParent);
                    } else {
                        if (parentId != null) {
                            return this.findById(parentId).switchIfEmpty(Mono.fromRunnable(() -> {
                                data.setParentId(null);
                                data.setLevel(Integer.valueOf(1));
                                data.setPath(old.getPath());
                            })).doOnNext(pathRefactor).thenReturn(data);
                        }
                        data.setPath(old.getPath());
                    }
                }
                return Mono.just((Object)data);
            });
        });
    }

    @Override
    default public Mono<SaveResult> save(Collection<E> collection) {
        return this.save((E)Flux.fromIterable(collection));
    }

    @Override
    default public Mono<SaveResult> save(E data) {
        return this.save((E)Flux.just(data));
    }

    @Override
    default public Mono<Integer> updateById(K id, Mono<E> entityPublisher) {
        return this.save((E)entityPublisher.doOnNext(e -> e.setId(id))).map(SaveResult::getTotal);
    }

    @Override
    default public Mono<Integer> deleteById(Publisher<K> idPublisher) {
        return (Mono)this.findById(Flux.from(idPublisher)).concatMap(e -> StringUtils.hasText((String)e.getPath()) ? ((ReactiveDelete)((ReactiveDelete)this.createDelete().where()).like$(() -> ((TreeSortSupportEntity)e).getPath())).execute() : this.getRepository().deleteById(e.getId())).as(MathFlux::sumInt);
    }

    public IDGenerator<K> getIDGenerator();

    public void setChildren(E var1, List<E> var2);

    default public List<E> getChildren(E entity) {
        return entity.getChildren();
    }

    default public Predicate<E> createRootNodePredicate(TreeSupportEntity.TreeHelper<E, K> helper) {
        return node -> {
            if (this.isRootNode(node)) {
                return true;
            }
            if (!StringUtils.isEmpty((Object)node.getParentId())) {
                return helper.getNode(node.getParentId()) == null;
            }
            return false;
        };
    }

    default public boolean isRootNode(E entity) {
        return StringUtils.isEmpty((Object)entity.getParentId()) || "-1".equals(String.valueOf(entity.getParentId()));
    }
}

