/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.sql;

import java.sql.Connection;
import javax.sql.DataSource;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.jdbc.JdbcReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class DefaultJdbcReactiveExecutor
extends JdbcReactiveSqlExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultJdbcReactiveExecutor.class);
    @Autowired
    private DataSource dataSource;

    protected String getDatasourceId() {
        return DataSourceHolder.switcher().datasource().current().orElse("default");
    }

    private Tuple2<DataSource, Connection> getDataSourceAndConnection() {
        DataSource dataSource = DataSourceHolder.isDynamicDataSourceReady() ? DataSourceHolder.currentDataSource().getNative() : this.dataSource;
        Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
        boolean isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)dataSource);
        if (log.isDebugEnabled()) {
            log.debug("DataSource ({}) JDBC Connection [{}] will {}be managed by Spring", new Object[]{this.getDatasourceId(), connection, isConnectionTransactional ? "" : "not "});
        }
        return Tuples.of((Object)dataSource, (Object)connection);
    }

    public Mono<Connection> getConnection() {
        return Mono.using(this::getDataSourceAndConnection, tp2 -> Mono.just((Object)tp2.getT2()), tp2 -> DataSourceUtils.releaseConnection((Connection)((Connection)tp2.getT2()), (DataSource)((DataSource)tp2.getT1())), (boolean)false);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager", readOnly=true)
    public <E> Flux<E> select(String sql, ResultWrapper<E, ?> wrapper) {
        return super.select(sql, wrapper);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager", rollbackFor={Throwable.class})
    public Mono<Integer> update(Publisher<SqlRequest> request) {
        return super.update(request);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager", rollbackFor={Throwable.class})
    public Mono<Integer> update(String sql, Object ... args) {
        return super.update(sql, args);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager", rollbackFor={Throwable.class})
    public Mono<Integer> update(SqlRequest request) {
        return super.update(request);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager", rollbackFor={Throwable.class})
    public Mono<Void> execute(Publisher<SqlRequest> request) {
        return super.execute(request);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager", rollbackFor={Throwable.class})
    public Mono<Void> execute(SqlRequest request) {
        return super.execute(request);
    }
}

