/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.exception.AuthenticationException;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.authorization.token.TokenState;
import org.hswebframework.web.crud.web.ResponseMessage;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.exception.I18nSupportException;
import org.hswebframework.web.exception.NotFoundException;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.logger.ReactiveLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Mono;

@RestControllerAdvice
@Order
public class CommonErrorControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(CommonErrorControllerAdvice.class);

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<ResponseMessage<Object>> handleException(BusinessException e) {
        return LocaleUtils.resolveThrowable((I18nSupportException)e, (err, msg) -> ResponseMessage.error(err.getStatus(), err.getCode(), msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<ResponseMessage<Object>> handleException(UnsupportedOperationException e) {
        return LocaleUtils.resolveThrowable((Throwable)e, (err, msg) -> ResponseMessage.error(500, "unsupported", msg), (Object[])new Object[0]).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public Mono<ResponseMessage<TokenState>> handleException(UnAuthorizedException e) {
        return LocaleUtils.resolveThrowable((I18nSupportException)e, (err, msg) -> ResponseMessage.error(401, "unauthorized", msg).result(e.getState()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public Mono<ResponseMessage<Object>> handleException(AccessDenyException e) {
        return LocaleUtils.resolveThrowable((I18nSupportException)e, (err, msg) -> ResponseMessage.error(403, e.getCode(), msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Mono<ResponseMessage<Object>> handleException(NotFoundException e) {
        return LocaleUtils.resolveThrowable((I18nSupportException)e, (err, msg) -> ResponseMessage.error(404, "not_found", msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(org.hswebframework.web.exception.ValidationException e) {
        return LocaleUtils.currentReactive().map(locale -> ResponseMessage.error(400, "illegal_argument", e.getLocalizedMessage(locale)).result(e.getDetails(locale)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(ConstraintViolationException e) {
        return this.handleException(new org.hswebframework.web.exception.ValidationException(e.getConstraintViolations()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(BindException e) {
        return this.handleBindingResult(e.getBindingResult());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(WebExchangeBindException e) {
        return this.handleBindingResult(e.getBindingResult());
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(MethodArgumentNotValidException e) {
        return this.handleBindingResult(e.getBindingResult());
    }

    private Mono<ResponseMessage<List<ValidationException.Detail>>> handleBindingResult(BindingResult result) {
        FieldError fieldError = result.getFieldError();
        ObjectError globalError = result.getGlobalError();
        String message = null != fieldError ? fieldError.getDefaultMessage() : (null != globalError ? globalError.getDefaultMessage() : "illegal_argument");
        List details = result.getFieldErrors().stream().map(err -> new ValidationException.Detail(err.getField(), err.getDefaultMessage(), null)).collect(Collectors.toList());
        return this.handleException(new org.hswebframework.web.exception.ValidationException(message, details, new Object[0]));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<?>> handleException(ValidationException e) {
        return Mono.just(ResponseMessage.error(400, "illegal_argument", e.getMessage()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.GATEWAY_TIMEOUT)
    public Mono<ResponseMessage<Object>> handleException(TimeoutException e) {
        return LocaleUtils.resolveThrowable((Throwable)e, (err, msg) -> ResponseMessage.error(504, "timeout", msg), (Object[])new Object[0]).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @Order
    public Mono<ResponseMessage<Object>> handleException(RuntimeException e) {
        return LocaleUtils.resolveThrowable((Throwable)e, (err, msg) -> ResponseMessage.error(msg), (Object[])new Object[0]).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<ResponseMessage<Object>> handleException(NullPointerException e) {
        return Mono.just(ResponseMessage.error(e.getMessage())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(IllegalArgumentException e) {
        return LocaleUtils.resolveThrowable((Throwable)e, (err, msg) -> ResponseMessage.error(400, "illegal_argument", msg), (Object[])new Object[0]).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(AuthenticationException e) {
        return LocaleUtils.resolveThrowable((I18nSupportException)e, (err, msg) -> ResponseMessage.error(400, err.getCode(), msg));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public Mono<ResponseMessage<Object>> handleException(UnsupportedMediaTypeStatusException e) {
        return LocaleUtils.resolveMessageReactive((String)"error.unsupported_media_type", (Object[])new Object[0]).map(msg -> ResponseMessage.error(415, "unsupported_media_type", msg).result(e.getSupportedMediaTypes())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getLocalizedMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Mono<ResponseMessage<Object>> handleException(NotAcceptableStatusException e) {
        return LocaleUtils.resolveMessageReactive((String)"error.not_acceptable_media_type", (Object[])new Object[0]).map(msg -> ResponseMessage.error(406, "not_acceptable_media_type", msg).result(e.getSupportedMediaTypes())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Mono<ResponseMessage<Object>> handleException(MethodNotAllowedException e) {
        return LocaleUtils.resolveMessageReactive((String)"error.method_not_allowed", (Object[])new Object[0]).map(msg -> ResponseMessage.error(406, "method_not_allowed", msg).result(e.getSupportedMethods())).doOnEach(ReactiveLogger.onNext(r -> log.error(e.getMessage(), (Throwable)e)));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<List<ValidationException.Detail>>> handleException(ServerWebInputException e) {
        Object exception = e;
        do {
            if (!((exception = exception.getCause()) instanceof org.hswebframework.web.exception.ValidationException)) continue;
            return this.handleException((org.hswebframework.web.exception.ValidationException)exception);
        } while (exception != null && exception != e);
        if (exception == null) {
            return Mono.just(ResponseMessage.error(400, "illegal_argument", e.getMessage()));
        }
        return LocaleUtils.resolveThrowable((Throwable)exception, (err, msg) -> ResponseMessage.error(400, "illegal_argument", msg), (Object[])new Object[0]);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<Object>> handleException(I18nSupportException e) {
        return e.getLocalizedMessageReactive().map(msg -> ResponseMessage.error(400, e.getI18nCode(), msg));
    }
}

