/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.GlobalConfig;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.events.ContextKey;
import org.hswebframework.ezorm.rdb.events.ContextKeys;
import org.hswebframework.ezorm.rdb.events.EventContext;
import org.hswebframework.ezorm.rdb.events.EventListener;
import org.hswebframework.ezorm.rdb.events.EventType;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.ezorm.rdb.mapping.DSLUpdate;
import org.hswebframework.ezorm.rdb.mapping.EntityColumnMapping;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.SyncQuery;
import org.hswebframework.ezorm.rdb.mapping.SyncRepository;
import org.hswebframework.ezorm.rdb.mapping.events.MappingContextKeys;
import org.hswebframework.ezorm.rdb.mapping.events.MappingEventTypes;
import org.hswebframework.ezorm.rdb.mapping.events.ReactiveResultHolder;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.web.api.crud.entity.Entity;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.crud.events.EntityBeforeCreateEvent;
import org.hswebframework.web.crud.events.EntityBeforeDeleteEvent;
import org.hswebframework.web.crud.events.EntityBeforeModifyEvent;
import org.hswebframework.web.crud.events.EntityBeforeQueryEvent;
import org.hswebframework.web.crud.events.EntityBeforeSaveEvent;
import org.hswebframework.web.crud.events.EntityCreatedEvent;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityEventHelper;
import org.hswebframework.web.crud.events.EntityEventListenerConfigure;
import org.hswebframework.web.crud.events.EntityEventPhase;
import org.hswebframework.web.crud.events.EntityEventType;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntityPrepareCreateEvent;
import org.hswebframework.web.crud.events.EntityPrepareModifyEvent;
import org.hswebframework.web.crud.events.EntityPrepareSaveEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.crud.events.SqlExpressionInvoker;
import org.hswebframework.web.event.AsyncEvent;
import org.hswebframework.web.event.GenericsPayloadApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.Ordered;
import reactor.core.publisher.Mono;
import reactor.function.Function3;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class EntityEventListener
implements EventListener,
Ordered {
    public static final ContextKey<List<Object>> readyToDeleteContextKey = ContextKey.of((String)"readyToDelete");
    public static final ContextKey<List<Object>> readyToUpdateContextKey = ContextKey.of((String)"readyToUpdate");
    private final ApplicationEventPublisher eventPublisher;
    private final EntityEventListenerConfigure listenerConfigure;
    private SqlExpressionInvoker expressionInvoker;

    public String getId() {
        return "entity-listener";
    }

    public String getName() {
        return "\u5b9e\u4f53\u53d8\u66f4\u4e8b\u4ef6\u76d1\u542c\u5668";
    }

    public void onEvent(EventType type, EventContext context) {
        boolean single;
        Class entityType;
        if (context.get(MappingContextKeys.error).isPresent()) {
            return;
        }
        EntityColumnMapping mapping = context.get(MappingContextKeys.columnMapping).orElse(null);
        if (mapping == null || !Entity.class.isAssignableFrom(entityType = mapping.getEntityType()) || !this.listenerConfigure.isEnabled(entityType)) {
            return;
        }
        if (type == MappingEventTypes.select_before) {
            this.handleQueryBefore(mapping, context);
        }
        if (type == MappingEventTypes.insert_before) {
            single = context.get(MappingContextKeys.type).map("single"::equals).orElse(false);
            if (single) {
                this.handleSingleOperation(mapping.getEntityType(), EntityEventType.create, context, EntityPrepareCreateEvent::new, EntityBeforeCreateEvent::new, EntityCreatedEvent::new);
            } else {
                this.handleBatchOperation(mapping.getEntityType(), EntityEventType.save, context, EntityPrepareSaveEvent::new, EntityBeforeCreateEvent::new, EntityCreatedEvent::new);
            }
        }
        if (type == MappingEventTypes.save_before) {
            single = context.get(MappingContextKeys.type).map("single"::equals).orElse(false);
            if (single) {
                this.handleSingleOperation(mapping.getEntityType(), EntityEventType.save, context, EntityPrepareSaveEvent::new, EntityBeforeSaveEvent::new, EntitySavedEvent::new);
            } else {
                this.handleBatchOperation(mapping.getEntityType(), EntityEventType.save, context, EntityPrepareSaveEvent::new, EntityBeforeSaveEvent::new, EntitySavedEvent::new);
            }
        }
        if (type == MappingEventTypes.update_before) {
            this.handleUpdateBefore(context);
        }
        if (type == MappingEventTypes.delete_before) {
            this.handleDeleteBefore(entityType, context);
        }
    }

    protected void handleQueryBefore(EntityColumnMapping mapping, EventContext context) {
        context.get(MappingContextKeys.reactiveResultHolder).ifPresent(holder -> context.get(MappingContextKeys.queryOaram).ifPresent(queryParam -> {
            EntityBeforeQueryEvent event = new EntityBeforeQueryEvent((QueryParam)queryParam, mapping.getEntityType());
            this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, event, new Class[]{mapping.getEntityType()}));
            holder.before(event.getAsync());
        }));
    }

    protected List<Object> createAfterData(List<Object> olds, EventContext context) {
        ArrayList<Object> newValues = new ArrayList<Object>(olds.size());
        EntityColumnMapping mapping = (EntityColumnMapping)context.get(MappingContextKeys.columnMapping).orElseThrow(UnsupportedOperationException::new);
        Map columns = context.get(MappingContextKeys.updateColumnInstance).orElse(Collections.emptyMap());
        for (Object old : olds) {
            Map<String, Object> oldMap = null;
            Object data = FastBeanCopier.copy((Object)old, (Object)mapping.newInstance(), (String[])new String[0]);
            for (Map.Entry entry : columns.entrySet()) {
                RDBColumnMetadata column = mapping.getColumnByName((String)entry.getKey()).orElse(null);
                if (column == null) continue;
                Object value = entry.getValue();
                if (value instanceof NullValue) {
                    value = null;
                }
                if (value instanceof NativeSql) {
                    Object object = this.expressionInvoker == null ? null : (value = this.expressionInvoker.invoke((NativeSql)value, mapping, oldMap == null ? this.createFullMapping(old, mapping) : oldMap));
                    if (value == null) continue;
                }
                GlobalConfig.getPropertyOperator().setProperty(data, column.getAlias(), value);
            }
            newValues.add(data);
        }
        return newValues;
    }

    protected Map<String, Object> createFullMapping(Object old, EntityColumnMapping mapping) {
        Map map = (Map)FastBeanCopier.copy((Object)old, new HashMap(), (String[])new String[0]);
        for (RDBColumnMetadata column : mapping.getTable().getColumns()) {
            if (!map.containsKey(column.getAlias())) continue;
            map.put(column.getName(), map.get(column.getAlias()));
        }
        return map;
    }

    protected Mono<Void> sendUpdateEvent(List<Object> before, List<Object> after, Class<Object> type, Function3<List<Object>, List<Object>, Class<Object>, AsyncEvent> mapper) {
        return EntityEventHelper.publishEvent(this, type, () -> (AsyncEvent)mapper.apply((Object)before, (Object)after, (Object)type), arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0));
    }

    protected Mono<Void> sendDeleteEvent(List<Object> olds, Class<Object> type, BiFunction<List<Object>, Class<Object>, AsyncEvent> eventBuilder) {
        return EntityEventHelper.publishEvent(this, type, () -> (AsyncEvent)eventBuilder.apply(olds, type), arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0));
    }

    protected void handleUpdateBefore(DSLUpdate<?, ?> update, EventContext context) {
        Object repo = context.get(MappingContextKeys.repository).orElse(null);
        EntityColumnMapping mapping = (EntityColumnMapping)context.get(MappingContextKeys.columnMapping).orElseThrow(UnsupportedOperationException::new);
        Class entityType = mapping.getEntityType();
        if (repo instanceof ReactiveRepository) {
            ReactiveResultHolder holder = context.get(MappingContextKeys.reactiveResultHolder).orElse(null);
            if (holder != null) {
                AtomicReference updated = new AtomicReference();
                if (this.isEnabled(entityType, EntityEventType.modify, EntityEventPhase.prepare, EntityEventPhase.before, EntityEventPhase.after)) {
                    holder.before(this.doAsyncEvent(() -> ((ReactiveQuery)((ReactiveRepository)repo).createQuery().setParam(update.toQueryParam())).fetch().collectList().flatMap(list -> {
                        if (list.isEmpty()) {
                            return Mono.empty();
                        }
                        List<Object> after = this.createAfterData((List<Object>)list, context);
                        updated.set(Tuples.of((Object)list, after));
                        return this.sendUpdateEvent((List<Object>)list, after, entityType, (Function3<List<Object>, List<Object>, Class<Object>, AsyncEvent>)((Function3)EntityPrepareModifyEvent::new));
                    }).then()));
                }
                if (this.isEnabled(entityType, EntityEventType.modify, EntityEventPhase.before)) {
                    holder.invoke(this.doAsyncEvent(() -> {
                        Tuple2 _tmp = (Tuple2)updated.get();
                        if (_tmp != null) {
                            return this.sendUpdateEvent((List)_tmp.getT1(), (List)_tmp.getT2(), entityType, (Function3<List<Object>, List<Object>, Class<Object>, AsyncEvent>)((Function3)EntityBeforeModifyEvent::new));
                        }
                        return Mono.empty();
                    }));
                }
                if (this.isEnabled(entityType, EntityEventType.modify, EntityEventPhase.after)) {
                    holder.after(v -> this.doAsyncEvent(() -> {
                        Tuple2 _tmp = updated.getAndSet(null);
                        if (_tmp != null) {
                            return this.sendUpdateEvent((List)_tmp.getT1(), (List)_tmp.getT2(), entityType, (Function3<List<Object>, List<Object>, Class<Object>, AsyncEvent>)((Function3)EntityModifyEvent::new));
                        }
                        return Mono.empty();
                    }));
                }
            }
        } else if (repo instanceof SyncRepository && this.isEnabled(entityType, EntityEventType.modify, EntityEventPhase.before)) {
            QueryParam param = update.toQueryParam();
            SyncRepository syncRepository = repo;
            List list = ((SyncQuery)syncRepository.createQuery().setParam(param)).fetch();
            if (list.isEmpty()) {
                return;
            }
            this.sendUpdateEvent(list, this.createAfterData(list, context), mapping.getEntityType(), (Function3<List<Object>, List<Object>, Class<Object>, AsyncEvent>)((Function3)EntityBeforeModifyEvent::new)).block();
        }
    }

    protected void handleUpdateBefore(EventContext context) {
        context.get(ContextKeys.source()).ifPresent(dslUpdate -> this.handleUpdateBefore((DSLUpdate<?, ?>)dslUpdate, context));
    }

    protected void handleDeleteBefore(Class<Entity> entityType, EventContext context) {
        EntityColumnMapping mapping = (EntityColumnMapping)context.get(MappingContextKeys.columnMapping).orElseThrow(UnsupportedOperationException::new);
        context.get(ContextKeys.source()).ifPresent(dslUpdate -> {
            Object repo = context.get(MappingContextKeys.repository).orElse(null);
            if (repo instanceof ReactiveRepository) {
                context.get(MappingContextKeys.reactiveResultHolder).ifPresent(holder -> {
                    AtomicReference deleted = new AtomicReference();
                    if (this.isEnabled(entityType, EntityEventType.delete, EntityEventPhase.before, EntityEventPhase.after)) {
                        holder.before(this.doAsyncEvent(() -> ((ReactiveQuery)((ReactiveRepository)repo).createQuery().setParam(dslUpdate.toQueryParam())).fetch().collectList().doOnNext(list -> context.set(readyToDeleteContextKey, list)).filter(CollectionUtils::isNotEmpty).flatMap(list -> {
                            deleted.set(list);
                            return this.sendDeleteEvent((List<Object>)list, mapping.getEntityType(), EntityBeforeDeleteEvent::new);
                        })));
                    }
                    if (this.isEnabled(entityType, EntityEventType.delete, EntityEventPhase.after)) {
                        holder.after(v -> this.doAsyncEvent(() -> {
                            List _tmp = deleted.getAndSet(null);
                            if (CollectionUtils.isNotEmpty((Collection)_tmp)) {
                                return this.sendDeleteEvent(_tmp, mapping.getEntityType(), EntityDeletedEvent::new);
                            }
                            return Mono.empty();
                        }));
                    }
                });
            } else if (repo instanceof SyncRepository) {
                QueryParam param = dslUpdate.toQueryParam();
                SyncRepository syncRepository = repo;
                List list = ((SyncQuery)syncRepository.createQuery().setParam(param)).fetch();
                this.sendDeleteEvent(list, mapping.getEntityType(), EntityBeforeDeleteEvent::new).block();
            }
        });
    }

    protected void handleUpdateAfter(EventContext context) {
    }

    protected void handleBatchOperation(Class clazz, EntityEventType entityEventType, EventContext context, BiFunction<List<?>, Class, AsyncEvent> before, BiFunction<List<?>, Class, AsyncEvent> execute, BiFunction<List<?>, Class, AsyncEvent> after) {
        Optional resultHolder;
        List lst = context.get(MappingContextKeys.instance).filter(List.class::isInstance).map(List.class::cast).orElse(null);
        if (lst == null) {
            return;
        }
        AsyncEvent prepareEvent = before.apply(lst, clazz);
        AsyncEvent afterEvent = after.apply(lst, clazz);
        AsyncEvent beforeEvent = execute.apply(lst, clazz);
        Object repo = context.get(MappingContextKeys.repository).orElse(null);
        if (repo instanceof ReactiveRepository && (resultHolder = context.get(MappingContextKeys.reactiveResultHolder)).isPresent()) {
            ReactiveResultHolder holder = (ReactiveResultHolder)resultHolder.get();
            if (null != prepareEvent && this.isEnabled(clazz, entityEventType, EntityEventPhase.prepare)) {
                holder.before(this.doAsyncEvent(() -> EntityEventHelper.publishEvent(this, clazz, () -> prepareEvent, arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0))));
            }
            if (null != beforeEvent && this.isEnabled(clazz, entityEventType, EntityEventPhase.before)) {
                holder.invoke(this.doAsyncEvent(() -> EntityEventHelper.publishEvent(this, clazz, () -> beforeEvent, arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0))));
            }
            if (null != afterEvent && this.isEnabled(clazz, entityEventType, EntityEventPhase.after)) {
                holder.after(v -> this.doAsyncEvent(() -> EntityEventHelper.publishEvent(this, clazz, () -> afterEvent, arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0))));
            }
            return;
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, (Object)afterEvent, new Class[]{clazz}));
        afterEvent.getAsync().block();
    }

    boolean isEnabled(Class clazz, EntityEventType entityEventType, EntityEventPhase ... phase) {
        for (EntityEventPhase entityEventPhase : phase) {
            if (!this.listenerConfigure.isEnabled(clazz, entityEventType, entityEventPhase)) continue;
            return true;
        }
        return false;
    }

    protected void handleSingleOperation(Class clazz, EntityEventType entityEventType, EventContext context, BiFunction<List<?>, Class, AsyncEvent> before, BiFunction<List<?>, Class, AsyncEvent> execute, BiFunction<List<?>, Class, AsyncEvent> after) {
        context.get(MappingContextKeys.instance).filter(Entity.class::isInstance).map(Entity.class::cast).ifPresent(entity -> {
            Optional resultHolder;
            AsyncEvent prepareEvent = (AsyncEvent)before.apply(Collections.singletonList(entity), clazz);
            AsyncEvent beforeEvent = (AsyncEvent)execute.apply(Collections.singletonList(entity), clazz);
            AsyncEvent afterEvent = (AsyncEvent)after.apply(Collections.singletonList(entity), clazz);
            Object repo = context.get(MappingContextKeys.repository).orElse(null);
            if (repo instanceof ReactiveRepository && (resultHolder = context.get(MappingContextKeys.reactiveResultHolder)).isPresent()) {
                ReactiveResultHolder holder = (ReactiveResultHolder)resultHolder.get();
                if (null != prepareEvent && this.isEnabled(clazz, entityEventType, EntityEventPhase.prepare)) {
                    holder.before(this.doAsyncEvent(() -> EntityEventHelper.publishEvent(this, clazz, () -> prepareEvent, arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0))));
                }
                if (null != beforeEvent && this.isEnabled(clazz, entityEventType, EntityEventPhase.before)) {
                    holder.invoke(this.doAsyncEvent(() -> EntityEventHelper.publishEvent(this, clazz, () -> beforeEvent, arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0))));
                }
                if (null != afterEvent && this.isEnabled(clazz, entityEventType, EntityEventPhase.after)) {
                    holder.after(v -> this.doAsyncEvent(() -> EntityEventHelper.publishEvent(this, clazz, () -> afterEvent, arg_0 -> ((ApplicationEventPublisher)this.eventPublisher).publishEvent(arg_0))));
                }
                return;
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, (Object)afterEvent, new Class[]{clazz}));
            afterEvent.getAsync().block();
        });
    }

    protected Mono<Void> doAsyncEvent(Supplier<Mono<Void>> eventSupplier) {
        return EntityEventHelper.tryFireEvent(eventSupplier);
    }

    public int getOrder() {
        return 2147483547;
    }

    public EntityEventListener(ApplicationEventPublisher eventPublisher, EntityEventListenerConfigure listenerConfigure) {
        this.eventPublisher = eventPublisher;
        this.listenerConfigure = listenerConfigure;
    }

    public void setExpressionInvoker(SqlExpressionInvoker expressionInvoker) {
        this.expressionInvoker = expressionInvoker;
    }
}

