/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.events.expr;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import org.hswebframework.web.crud.events.expr.AbstractSqlExpressionInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.Operation;
import org.springframework.expression.OperatorOverloader;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectiveMethodResolver;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class SpelSqlExpressionInvoker
extends AbstractSqlExpressionInvoker {
    private static final Logger log = LoggerFactory.getLogger(SpelSqlExpressionInvoker.class);
    static final FastThreadLocal<StandardEvaluationContext> SHARED_CONTEXT = new FastThreadLocal<StandardEvaluationContext>(){

        protected StandardEvaluationContext initialValue() {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.addPropertyAccessor((PropertyAccessor)accessor);
            context.addMethodResolver((MethodResolver)new ReflectiveMethodResolver(){

                public MethodExecutor resolve(@Nonnull EvaluationContext context, @Nonnull Object targetObject, @Nonnull String name, @Nonnull List<TypeDescriptor> argumentTypes) throws AccessException {
                    return super.resolve(context, targetObject, name.toLowerCase(), argumentTypes);
                }
            });
            context.setOperatorOverloader(new OperatorOverloader(){

                public boolean overridesOperation(@Nonnull Operation operation, Object leftOperand, Object rightOperand) throws EvaluationException {
                    if (leftOperand instanceof Number || rightOperand instanceof Number) {
                        return leftOperand == null || rightOperand == null;
                    }
                    return leftOperand == null && rightOperand == null;
                }

                public Object operate(@Nonnull Operation operation, Object leftOperand, Object rightOperand) throws EvaluationException {
                    return null;
                }
            });
            return context;
        }
    };
    static ExtMapAccessor accessor = new ExtMapAccessor();

    @Override
    protected BiFunction<Object[], Map<String, Object>, Object> compile(String sql) {
        StringBuilder builder = new StringBuilder(sql.length());
        int argIndex = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '?') {
                builder.append("_arg").append(argIndex++);
                continue;
            }
            builder.append(c);
        }
        try {
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression expression = parser.parseExpression(builder.toString());
            AtomicLong errorCount = new AtomicLong();
            return (args, object) -> {
                if (errorCount.get() > 1024L) {
                    return null;
                }
                object = this.createArguments((Map<String, Object>)object);
                if (args != null && ((Object[])args).length != 0) {
                    int index = 0;
                    for (Object parameter : args) {
                        object.put("_arg" + index, parameter);
                    }
                }
                StandardEvaluationContext context = (StandardEvaluationContext)SHARED_CONTEXT.get();
                try {
                    context.setRootObject(object);
                    Object val = expression.getValue((EvaluationContext)context);
                    errorCount.set(0L);
                    Object object2 = val;
                    return object2;
                }
                catch (Throwable err) {
                    log.warn("invoke native sql [{}] value error", (Object)sql, (Object)err);
                    errorCount.incrementAndGet();
                }
                finally {
                    context.setRootObject(null);
                }
                return null;
            };
        }
        catch (Throwable error) {
            return this.spelError(sql, error);
        }
    }

    protected SqlFunctions createArguments(Map<String, Object> args) {
        return new SqlFunctions(args);
    }

    protected BiFunction<Object[], Map<String, Object>, Object> spelError(String sql, Throwable error) {
        log.warn("create sql expression [{}] parser error", (Object)sql, (Object)error);
        return (args, data) -> null;
    }

    static class ExtMapAccessor
    extends MapAccessor {
        ExtMapAccessor() {
        }

        public boolean canRead(@Nonnull EvaluationContext context, Object target, @Nonnull String name) throws AccessException {
            return target instanceof Map;
        }

        @Nonnull
        public TypedValue read(@Nonnull EvaluationContext context, Object target, @Nonnull String name) throws AccessException {
            Assert.state((boolean)(target instanceof Map), (String)"Target must be of type Map");
            Map map = (Map)target;
            Object value = map.get(name);
            return new TypedValue(value);
        }
    }

    protected static class SqlFunctions
    extends HashMap<String, Object> {
        public SqlFunctions(Map<String, Object> map) {
            super(map);
        }

        public String lower(Object str) {
            return String.valueOf(str).toLowerCase();
        }

        public String upper(Object str) {
            return String.valueOf(str).toUpperCase();
        }

        public String substring(Object str, int start, int length) {
            return String.valueOf(str).substring(start, length);
        }

        public String trim(Object str) {
            return String.valueOf(str).trim();
        }

        public String concat(Object ... args) {
            StringBuilder builder = new StringBuilder();
            for (Object arg : args) {
                builder.append(arg);
            }
            return builder.toString();
        }

        public Object coalesce(Object ... args) {
            for (Object arg : args) {
                if (arg == null) continue;
                return arg;
            }
            return null;
        }
    }
}

