/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.generator;

import java.util.HashMap;
import java.util.Map;
import org.hswebframework.ezorm.core.DefaultValue;
import org.hswebframework.ezorm.core.DefaultValueGenerator;
import org.hswebframework.ezorm.core.meta.ObjectMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIdGenerator
implements DefaultValueGenerator<RDBColumnMetadata> {
    private static final Logger log = LoggerFactory.getLogger(DefaultIdGenerator.class);
    private String defaultId = "snow_flake";
    private Map<String, String> mappings = new HashMap<String, String>();

    public String getSortId() {
        return "default_id";
    }

    public DefaultValue generate(RDBColumnMetadata metadata) {
        String genId = this.mappings.getOrDefault(metadata.getOwner().getName(), this.defaultId);
        DefaultValueGenerator generator = (DefaultValueGenerator)metadata.findFeatureNow(DefaultValueGenerator.createId((String)genId));
        log.debug("use default id generator : {} for column : {}", (Object)generator.getSortId(), (Object)metadata.getFullName());
        return generator.generate((ObjectMetadata)metadata);
    }

    public String getName() {
        return "\u9ed8\u8ba4ID\u751f\u6210\u5668";
    }

    public String getDefaultId() {
        return this.defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }
}

