/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;

public interface QueryAnalyzer {
    public String originalSql();

    public SqlRequest refactor(QueryParamEntity var1, Object ... var2);

    public SqlRequest refactorCount(QueryParamEntity var1, Object ... var2);

    public Select select();

    public Optional<Column> findColumn(String var1);

    public boolean columnIsExpression(String var1, int var2);

    public List<Join> joins();

    public static class SelectTable
    extends Table {
        final Map<String, Column> columns;

        public SelectTable(String alias, Map<String, Column> columns, TableOrViewMetadata metadata) {
            super(alias, metadata);
            this.columns = columns;
        }

        public Map<String, Column> getColumns() {
            return Collections.unmodifiableMap(this.columns);
        }
    }

    public static class Column {
        String name;
        String alias;
        String owner;
        RDBColumnMetadata metadata;

        public Column(String name, String alias, String owner, RDBColumnMetadata metadata) {
            this.name = name;
            this.alias = alias;
            this.owner = owner;
            this.metadata = metadata;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getOwner() {
            return this.owner;
        }

        public RDBColumnMetadata getMetadata() {
            return this.metadata;
        }
    }

    public static class Table {
        final String alias;
        final TableOrViewMetadata metadata;

        public String getAlias() {
            return this.alias;
        }

        public TableOrViewMetadata getMetadata() {
            return this.metadata;
        }

        public Table(String alias, TableOrViewMetadata metadata) {
            this.alias = alias;
            this.metadata = metadata;
        }
    }

    public static class Select {
        private transient Map<String, Column> columns;
        final List<Column> columnList;
        final Table table;

        public Map<String, Column> getColumns() {
            return this.columns == null ? (this.columns = this.columnList.stream().collect(Collectors.toMap(Column::getAlias, Function.identity(), (a, b) -> b))) : this.columns;
        }

        public Select(List<Column> columnList, Table table) {
            this.columnList = columnList;
            this.table = table;
        }

        public List<Column> getColumnList() {
            return this.columnList;
        }

        public Table getTable() {
            return this.table;
        }
    }

    public static class Join {
        final String alias;
        final Type type;
        final Table table;

        public Join(String alias, Type type, Table table) {
            this.alias = alias;
            this.type = type;
            this.table = table;
        }

        public String getAlias() {
            return this.alias;
        }

        public Type getType() {
            return this.type;
        }

        public Table getTable() {
            return this.table;
        }

        static enum Type {
            left,
            right,
            inner;

        }
    }
}

