/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.Sort;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AbstractTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.EmptySqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.TermFragmentBuilder;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.crud.query.QueryAnalyzer;
import org.hswebframework.web.crud.query.QueryHelperUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class QueryAnalyzerImpl
implements FromItemVisitor,
SelectItemVisitor,
SelectVisitor,
QueryAnalyzer {
    private final DatabaseOperator database;
    private String sql;
    private final SelectBody parsed;
    private QueryAnalyzer.Select select;
    private final Map<String, QueryAnalyzer.Join> joins = new LinkedHashMap<String, QueryAnalyzer.Join>();
    private QueryRefactor injector;
    private volatile Map<String, QueryAnalyzer.Column> columnMappings;
    static QueryAnalyzerTermsFragmentBuilder TERMS_BUILDER = new QueryAnalyzerTermsFragmentBuilder();

    @Override
    public String originalSql() {
        return this.sql;
    }

    @Override
    public SqlRequest refactor(QueryParamEntity entity, Object ... args) {
        if (this.injector == null) {
            this.initInjector();
        }
        return this.injector.refactor(entity, args);
    }

    @Override
    public SqlRequest refactorCount(QueryParamEntity entity, Object ... args) {
        if (this.injector == null) {
            this.initInjector();
        }
        return this.injector.refactorCount(entity, args);
    }

    @Override
    public QueryAnalyzer.Select select() {
        return this.select;
    }

    @Override
    public Optional<QueryAnalyzer.Column> findColumn(String name) {
        return Optional.ofNullable(this.getColumnMappings().get(name));
    }

    @Override
    public List<QueryAnalyzer.Join> joins() {
        return new ArrayList<QueryAnalyzer.Join>(this.joins.values());
    }

    QueryAnalyzerImpl(DatabaseOperator database, String sql) {
        this(database, QueryAnalyzerImpl.parse(sql));
        this.sql = sql;
    }

    @Override
    public boolean columnIsExpression(String name, int index) {
        if (index >= 0 && this.select.getColumnList().size() > index) {
            return this.select.getColumnList().get(index) instanceof ExpressionColumn;
        }
        return this.select.getColumns().get(name) instanceof ExpressionColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, QueryAnalyzer.Column> getColumnMappings() {
        if (this.columnMappings == null) {
            QueryAnalyzerImpl queryAnalyzerImpl = this;
            synchronized (queryAnalyzerImpl) {
                if (this.columnMappings == null) {
                    this.columnMappings = new HashMap<String, QueryAnalyzer.Column>();
                    if (this.select.table instanceof QueryAnalyzer.SelectTable) {
                        for (Map.Entry entry : ((QueryAnalyzer.SelectTable)this.select.getTable()).getColumns().entrySet()) {
                            QueryAnalyzer.Column column = (QueryAnalyzer.Column)entry.getValue();
                            QueryAnalyzer.Column col = new QueryAnalyzer.Column(column.getName(), column.getAlias(), this.select.table.alias, column.metadata);
                            this.columnMappings.put((String)entry.getKey(), col);
                            this.columnMappings.put(this.select.table.alias + "." + (String)entry.getKey(), col);
                            if (column instanceof ExpressionColumn || column.metadata == null) continue;
                            this.columnMappings.put(column.metadata.getName(), col);
                            this.columnMappings.put(this.select.table.alias + "." + column.metadata.getName(), col);
                            this.columnMappings.put(column.metadata.getAlias(), col);
                            this.columnMappings.put(this.select.table.alias + "." + column.metadata.getAlias(), col);
                        }
                        for (QueryAnalyzer.Column column : this.select.getColumnList()) {
                            this.columnMappings.put(column.getName(), column);
                            this.columnMappings.put(column.getAlias(), column);
                            if (null == column.getOwner()) continue;
                            this.columnMappings.put(column.getOwner() + "." + column.getName(), column);
                            this.columnMappings.put(column.getOwner() + "." + column.getAlias(), column);
                        }
                    } else {
                        for (RDBColumnMetadata rDBColumnMetadata : this.select.table.metadata.getColumns()) {
                            QueryAnalyzer.Column col = new QueryAnalyzer.Column(rDBColumnMetadata.getName(), rDBColumnMetadata.getAlias(), this.select.table.alias, rDBColumnMetadata);
                            this.columnMappings.put(rDBColumnMetadata.getName(), col);
                            this.columnMappings.put(rDBColumnMetadata.getAlias(), col);
                            this.columnMappings.put(this.select.table.alias + "." + rDBColumnMetadata.getName(), col);
                            this.columnMappings.put(this.select.table.alias + "." + rDBColumnMetadata.getAlias(), col);
                        }
                    }
                    for (QueryAnalyzer.Join join : this.joins.values()) {
                        if (join.table instanceof QueryAnalyzer.SelectTable) {
                            for (QueryAnalyzer.Column column : this.select.getColumnList()) {
                                this.columnMappings.putIfAbsent(column.getName(), column);
                                this.columnMappings.putIfAbsent(column.getAlias(), column);
                                this.columnMappings.put(column.getOwner() + "." + column.getName(), column);
                                this.columnMappings.put(column.getOwner() + "." + column.getAlias(), column);
                            }
                            continue;
                        }
                        for (QueryAnalyzer.Column column : join.table.metadata.getColumns()) {
                            QueryAnalyzer.Column col = new QueryAnalyzer.Column(column.getName(), column.getAlias(), join.alias, (RDBColumnMetadata)column);
                            this.columnMappings.putIfAbsent(column.getName(), col);
                            this.columnMappings.putIfAbsent(column.getAlias(), col);
                            this.columnMappings.put(join.alias + "." + column.getName(), col);
                            this.columnMappings.put(join.alias + "." + column.getAlias(), col);
                        }
                    }
                }
            }
        }
        return this.columnMappings;
    }

    private QueryAnalyzer.Column getColumnOrSelectColumn(String name) {
        QueryAnalyzer.Column column = this.select.getColumns().get(name);
        if (column != null) {
            return column;
        }
        column = this.select.getColumns().get(QueryHelperUtils.toSnake(name));
        if (column != null) {
            return column;
        }
        return this.getColumnMappings().get(name);
    }

    private static SelectBody parse(String sql) {
        return ((Select)CCJSqlParserUtil.parse((String)sql)).getSelectBody();
    }

    QueryAnalyzerImpl(DatabaseOperator database, SelectBody selectBody) {
        this.database = database;
        if (null != selectBody) {
            this.parsed = selectBody;
            selectBody.accept((SelectVisitor)this);
        } else {
            this.parsed = null;
        }
    }

    private String parsePlainName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        char firstChar = name.charAt(0);
        if (firstChar == '`' || firstChar == '\"' || firstChar == '[' || name.startsWith(this.database.getMetadata().getDialect().getQuoteStart())) {
            return new String(name.toCharArray(), 1, name.length() - 2);
        }
        return name;
    }

    public void visit(Table tableName) {
        String schema = this.parsePlainName(tableName.getSchemaName());
        RDBSchemaMetadata schemaMetadata = schema != null ? (RDBSchemaMetadata)this.database.getMetadata().getSchema(schema).orElseThrow(() -> new IllegalStateException("schema " + schema + " not initialized")) : (RDBSchemaMetadata)this.database.getMetadata().getCurrentSchema();
        String alias = tableName.getAlias() == null ? tableName.getName() : tableName.getAlias().getName();
        QueryAnalyzer.Table table = new QueryAnalyzer.Table(this.parsePlainName(alias), (TableOrViewMetadata)schemaMetadata.getTableOrView(this.parsePlainName(tableName.getName()), false).orElseThrow(() -> new IllegalStateException("table or view " + tableName.getName() + " not found in " + schemaMetadata.getName())));
        this.select = new QueryAnalyzer.Select(new ArrayList<QueryAnalyzer.Column>(), table);
    }

    public void visit(SubSelect subSelect) {
        SelectBody body = subSelect.getSelectBody();
        QueryAnalyzerImpl sub = new QueryAnalyzerImpl(this.database, body);
        String alias = subSelect.getAlias() == null ? null : subSelect.getAlias().getName();
        LinkedHashMap<String, QueryAnalyzer.Column> columnMap = new LinkedHashMap<String, QueryAnalyzer.Column>();
        for (QueryAnalyzer.Column column : sub.select.getColumnList()) {
            columnMap.put(column.getAlias(), new QueryAnalyzer.Column(column.alias, column.getAlias(), column.owner, column.metadata));
        }
        this.select = new QueryAnalyzer.Select(new ArrayList<QueryAnalyzer.Column>(), new QueryAnalyzer.SelectTable(this.parsePlainName(alias), columnMap, sub.select.table.metadata));
    }

    public void visit(SubJoin subjoin) {
        for (Join join : subjoin.getJoinList()) {
            join.getRightItem().accept((FromItemVisitor)this);
        }
    }

    public void visit(LateralSubSelect lateralSubSelect) {
    }

    public void visit(ValuesList valuesList) {
    }

    public void visit(TableFunction tableFunction) {
    }

    public void visit(ParenthesisFromItem aThis) {
    }

    public void visit(AllColumns allColumns) {
        this.putSelectColumns(this.select.table, this.select.columnList);
        for (QueryAnalyzer.Join value : new HashSet<QueryAnalyzer.Join>(this.joins.values())) {
            this.putSelectColumns(value.table, this.select.columnList);
        }
    }

    private void putSelectColumns(QueryAnalyzer.Table table, List<QueryAnalyzer.Column> container) {
        if (table instanceof QueryAnalyzer.SelectTable) {
            QueryAnalyzer.SelectTable selectTable = (QueryAnalyzer.SelectTable)table;
            for (QueryAnalyzer.Column column : selectTable.columns.values()) {
                String alias = table == this.select.table ? column.getAlias() : table.alias + "." + column.getAlias();
                container.add(new QueryAnalyzer.Column(column.name, alias, table.alias, column.metadata));
            }
        } else {
            for (RDBColumnMetadata column : table.metadata.getColumns()) {
                String alias = table == this.select.table ? column.getAlias() : table.alias + "." + column.getAlias();
                container.add(new QueryAnalyzer.Column(column.getName(), alias, table.alias, column));
            }
        }
    }

    public void visit(AllTableColumns allTableColumns) {
        Table table = allTableColumns.getTable();
        String name = table.getName();
        if (Objects.equals(this.select.table.alias, name)) {
            this.putSelectColumns(this.select.table, this.select.columnList);
            return;
        }
        QueryAnalyzer.Join join = this.joins.get(this.parsePlainName(table.getName()));
        if (join == null) {
            throw new IllegalStateException("table " + table.getName() + " not found in join");
        }
        this.putSelectColumns(join.table, this.select.columnList);
    }

    private QueryAnalyzer.Table getTable(Table table) {
        QueryAnalyzer.Table meta;
        if (null == table) {
            return this.select.table;
        }
        String tableName = this.parsePlainName(table.getName());
        if (Objects.equals(tableName, this.select.table.alias)) {
            meta = this.select.table;
        } else {
            QueryAnalyzer.Join join = this.joins.get(tableName);
            if (join == null) {
                throw new IllegalStateException("table " + table + " not found in from or join");
            }
            meta = join.table;
        }
        return meta;
    }

    private void refactorAlias(Alias alias) {
        if (alias != null) {
            alias.setName(this.database.getMetadata().getDialect().quote(this.parsePlainName(alias.getName()), false));
        }
    }

    public void visit(SelectExpressionItem selectExpressionItem) {
        QueryAnalyzer.Column c;
        Expression expr = selectExpressionItem.getExpression();
        Alias alias = selectExpressionItem.getAlias();
        if (!(expr instanceof Column)) {
            String aliasName = this.parsePlainName(alias == null ? expr.toString() : alias.getName());
            this.refactorAlias(alias);
            this.select.columnList.add(new ExpressionColumn(aliasName, null, null, (SelectItem)selectExpressionItem));
            return;
        }
        Column column = (Column)expr;
        String columnName = this.parsePlainName(column.getColumnName());
        QueryAnalyzer.Table table = this.getTable(column.getTable());
        String aliasName = alias == null ? columnName : this.parsePlainName(alias.getName());
        RDBColumnMetadata metadata = table.getMetadata().getColumn(columnName).orElse(null);
        if (metadata == null && table instanceof QueryAnalyzer.SelectTable && null != (c = ((QueryAnalyzer.SelectTable)table).columns.get(columnName))) {
            metadata = c.metadata;
        }
        if (metadata == null) {
            throw new IllegalStateException("column [" + column.getColumnName() + "] not found in " + table.metadata.getName());
        }
        this.select.columnList.add(new QueryAnalyzer.Column(metadata.getName(), aliasName, table.alias, metadata));
    }

    public void visit(PlainSelect select) {
        FromItem from = select.getFromItem();
        if (from == null) {
            throw new IllegalArgumentException("select can not be without 'from'");
        }
        from.accept((FromItemVisitor)this);
        List joinList = select.getJoins();
        if (joinList != null) {
            for (Join join : joinList) {
                FromItem fromItem = join.getRightItem();
                QueryAnalyzerImpl joinAn = new QueryAnalyzerImpl(this.database, (SelectBody)null);
                fromItem.accept((FromItemVisitor)joinAn);
                QueryAnalyzer.Join.Type type = join.isLeft() ? QueryAnalyzer.Join.Type.left : (join.isRight() ? QueryAnalyzer.Join.Type.right : (join.isInner() ? QueryAnalyzer.Join.Type.inner : null));
                this.joins.put(joinAn.select.table.alias, new QueryAnalyzer.Join(joinAn.select.table.alias, type, joinAn.select.table));
            }
        }
        for (SelectItem selectItem : select.getSelectItems()) {
            selectItem.accept((SelectItemVisitor)this);
        }
    }

    public void visit(SetOperationList setOpList) {
        block0: {
            Iterator iterator = setOpList.getSelects().iterator();
            if (!iterator.hasNext()) break block0;
            SelectBody body = (SelectBody)iterator.next();
            body.accept((SelectVisitor)this);
        }
    }

    public void visit(WithItem withItem) {
    }

    public void visit(ValuesStatement aThis) {
    }

    private void initInjector() {
        SimpleQueryRefactor injector = new SimpleQueryRefactor();
        this.parsed.accept((SelectVisitor)injector);
        this.injector = injector;
    }

    private static interface QueryRefactor {
        public SqlRequest refactor(QueryParamEntity var1, Object ... var2);

        public SqlRequest refactorCount(QueryParamEntity var1, Object ... var2);
    }

    static class PrepareStatementVisitor
    extends ExpressionVisitorAdapter {
        private int parameterSize;

        PrepareStatementVisitor() {
        }

        public void visit(JdbcParameter parameter) {
            ++this.parameterSize;
            super.visit(parameter);
        }

        public int getParameterSize() {
            return this.parameterSize;
        }
    }

    class SimpleQueryRefactor
    implements QueryRefactor,
    SelectVisitor {
        private String from;
        private String columns;
        private String where;
        private int prefixParameters;
        private String orderBy;
        private String suffix;
        private int suffixParameters;
        private boolean fastCount = true;

        SimpleQueryRefactor() {
        }

        private void initColumns(StringBuilder columns) {
            int idx = 0;
            Dialect dialect = QueryAnalyzerImpl.this.database.getMetadata().getDialect();
            for (QueryAnalyzer.Column column : ((QueryAnalyzerImpl)QueryAnalyzerImpl.this).select.columnList) {
                if (idx++ > 0) {
                    columns.append(",");
                }
                if (column instanceof ExpressionColumn) {
                    columns.append(((ExpressionColumn)column).expr);
                    this.fastCount = false;
                    continue;
                }
                columns.append(column.owner).append('.').append(dialect.quote(column.name, column.metadata != null)).append(" as ").append(dialect.quote(column.alias, false));
            }
        }

        public void visit(PlainSelect plainSelect) {
            PrepareStatementVisitor visitor;
            StringBuilder from = new StringBuilder();
            StringBuilder columns = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            if (plainSelect.getDistinct() != null) {
                columns.append(plainSelect.getDistinct());
                this.fastCount = false;
            }
            this.initColumns(columns);
            if (plainSelect.getFromItem() != null) {
                from.append("FROM ");
                from.append(plainSelect.getFromItem());
            }
            if (plainSelect.getJoins() != null) {
                visitor = new PrepareStatementVisitor();
                for (Join join : plainSelect.getJoins()) {
                    if (join.isSimple()) {
                        from.append(", ").append(join);
                    } else {
                        from.append(" ").append(join);
                    }
                    if (null == join.getOnExpressions()) continue;
                    for (Expression onExpression : join.getOnExpressions()) {
                        onExpression.accept((ExpressionVisitor)visitor);
                    }
                }
                this.prefixParameters += visitor.parameterSize;
            }
            if (plainSelect.getWhere() != null) {
                visitor = new PrepareStatementVisitor();
                plainSelect.getWhere().accept((ExpressionVisitor)visitor);
                this.prefixParameters += visitor.parameterSize;
                this.where = plainSelect.getWhere().toString();
            }
            if (plainSelect.getOrderByElements() != null) {
                this.orderBy = PlainSelect.getFormatedList((List)plainSelect.getOrderByElements(), (String)"");
            }
            if (plainSelect.getGroupBy() != null) {
                this.fastCount = false;
                suffix.append(' ').append(plainSelect.getGroupBy());
            }
            suffix.append(' ');
            if (plainSelect.getHaving() != null) {
                visitor = new PrepareStatementVisitor();
                plainSelect.getHaving().accept((ExpressionVisitor)visitor);
                this.suffixParameters = visitor.parameterSize;
                suffix.append(" HAVING ").append(plainSelect.getHaving());
            }
            this.columns = columns.toString();
            this.from = from.toString();
            this.suffix = suffix.toString();
        }

        public void visit(SetOperationList setOpList) {
            StringBuilder from = new StringBuilder();
            StringBuilder columns = new StringBuilder();
            this.initColumns(columns);
            from.append("FROM (");
            from.append(setOpList);
            from.append(") ");
            from.append(((QueryAnalyzerImpl)QueryAnalyzerImpl.this).select.table.alias);
            this.from = from.toString();
            this.columns = columns.toString();
            this.suffix = "";
        }

        public void visit(WithItem withItem) {
        }

        public void visit(ValuesStatement aThis) {
        }

        public Object[] getPrefixParameters(Object ... args) {
            if (this.prefixParameters == 0) {
                return new Object[0];
            }
            Assert.isTrue((args.length >= this.prefixParameters ? 1 : 0) != 0, (String)("Illegal prepare statement parameter size, expect: " + this.prefixParameters + ", actual: " + args.length));
            return Arrays.copyOfRange(args, 0, this.prefixParameters);
        }

        public Object[] getSuffixParameters(Object ... args) {
            if (this.suffixParameters == 0) {
                return new Object[0];
            }
            Assert.isTrue((args.length >= this.suffixParameters + this.prefixParameters ? 1 : 0) != 0, (String)("Illegal prepare statement parameter size, expect: " + this.suffixParameters + this.prefixParameters + ", actual: " + args.length));
            return Arrays.copyOfRange(args, this.prefixParameters, this.suffixParameters + this.prefixParameters);
        }

        @Override
        public SqlRequest refactor(QueryParamEntity param, Object ... args) {
            PrepareSqlFragments sql = PrepareSqlFragments.of((String)"SELECT", (Object[])new Object[0]).addSql(new String[]{this.columns}).addSql(new String[]{this.from}).addParameter(this.getPrefixParameters(args));
            this.appendWhere(sql, param);
            sql.addSql(new String[]{this.suffix}).addParameter(this.getSuffixParameters(args));
            this.appendOrderBy(sql, param);
            return sql.toRequest();
        }

        @Override
        public SqlRequest refactorCount(QueryParamEntity param, Object ... args) {
            PrepareSqlFragments sql = PrepareSqlFragments.of((String)"SELECT", (Object[])this.getPrefixParameters(args));
            if (this.fastCount) {
                sql.addSql(new String[]{"count(1) as _total"});
                sql.addSql(new String[]{this.from});
                this.appendWhere(sql, param);
                sql.addSql(new String[]{this.suffix});
            } else {
                sql.addSql(new String[]{"count(1) as _total from (SELECT"}).addSql(new String[]{this.columns, this.from});
                this.appendWhere(sql, param);
                sql.addSql(new String[]{this.suffix}).addSql(new String[]{") _t"});
            }
            return sql.addParameter(this.getSuffixParameters(args)).toRequest();
        }

        private void appendOrderBy(PrepareSqlFragments sql, QueryParamEntity param) {
            if (CollectionUtils.isNotEmpty((Collection)param.getSorts())) {
                boolean customOrder;
                int index = 0;
                PrepareSqlFragments orderByValue = null;
                PrepareSqlFragments orderByColumn = null;
                for (Sort sort : param.getSorts()) {
                    String columnName;
                    String name = sort.getName();
                    QueryAnalyzer.Column column = QueryAnalyzerImpl.this.getColumnOrSelectColumn(name);
                    if (column == null) continue;
                    boolean desc = "desc".equalsIgnoreCase(sort.getOrder());
                    String string = columnName = column.getOwner() == null ? QueryAnalyzerImpl.this.database.getMetadata().getDialect().quote(column.getName(), false) : org.hswebframework.ezorm.core.utils.StringUtils.concat((Object[])new Object[]{column.getOwner(), ".", QueryAnalyzerImpl.this.database.getMetadata().getDialect().quote(column.getName())});
                    if (sort.getValue() != null) {
                        if (orderByValue == null) {
                            orderByValue = PrepareSqlFragments.of();
                            orderByValue.addSql(new String[]{"case"});
                        }
                        orderByValue.addSql(new String[]{"when"});
                        orderByValue.addSql(new String[]{columnName, "= ?"}).addParameter(new Object[]{sort.getValue()});
                        orderByValue.addSql(new String[]{"then"}).addSql(new String[]{String.valueOf(desc ? 10000 + index++ : index++)});
                        continue;
                    }
                    if (orderByColumn == null) {
                        orderByColumn = PrepareSqlFragments.of();
                    } else {
                        orderByColumn.addSql(new String[]{","});
                    }
                    orderByColumn.addSql(new String[]{columnName}).addSql(new String[]{desc ? "DESC" : "ASC"});
                }
                boolean bl = customOrder = orderByValue != null || orderByColumn != null;
                if (customOrder || this.orderBy != null) {
                    sql.addSql(new String[]{"ORDER BY"});
                }
                if (orderByValue != null) {
                    orderByValue.addSql(new String[]{"else 10000 end"});
                    sql.addFragments(orderByValue);
                }
                if (orderByColumn != null) {
                    if (orderByValue != null) {
                        sql.addSql(new String[]{","});
                    }
                    sql.addFragments(orderByColumn);
                }
                if (this.orderBy != null) {
                    if (customOrder) {
                        sql.addSql(new String[]{","});
                    }
                    sql.addSql(new String[]{this.orderBy});
                }
            } else if (this.orderBy != null) {
                sql.addSql(new String[]{"ORDER BY", this.orderBy});
            }
        }

        private void appendWhere(PrepareSqlFragments sql, QueryParamEntity param) {
            SqlFragments fragments = TERMS_BUILDER.createTermFragments(QueryAnalyzerImpl.this, (List<Term>)param.getTerms());
            if (fragments.isNotEmpty() || StringUtils.hasText((String)this.where)) {
                sql.addSql(new String[]{" WHERE "});
            }
            if (StringUtils.hasText((String)this.where)) {
                sql.addSql(new String[]{"("});
                sql.addSql(new String[]{this.where});
                sql.addSql(new String[]{")"});
            }
            if (fragments.isNotEmpty()) {
                if (StringUtils.hasText((String)this.where)) {
                    sql.addSql(new String[]{"AND"});
                }
                sql.addSql(new String[]{"("});
                sql.addFragments(fragments);
                sql.addSql(new String[]{")"});
            }
        }
    }

    static class QueryAnalyzerTermsFragmentBuilder
    extends AbstractTermsFragmentBuilder<QueryAnalyzerImpl> {
        QueryAnalyzerTermsFragmentBuilder() {
        }

        public SqlFragments createTermFragments(QueryAnalyzerImpl parameter, List<Term> terms) {
            return super.createTermFragments((Object)parameter, terms);
        }

        public SqlFragments createTermFragments(QueryAnalyzerImpl impl, Term term) {
            QueryAnalyzer.Table table;
            Dialect dialect = impl.database.getMetadata().getDialect();
            String column = term.getColumn();
            QueryAnalyzer.Column col = (QueryAnalyzer.Column)impl.getColumnMappings().get(column);
            if (col == null) {
                throw new IllegalArgumentException("undefined column [" + column + "]");
            }
            if (Objects.equals(((QueryAnalyzerImpl)impl).select.table.alias, col.getOwner())) {
                table = ((QueryAnalyzerImpl)impl).select.table;
            } else {
                QueryAnalyzer.Join join = (QueryAnalyzer.Join)impl.joins.get(col.getOwner());
                if (null != join) {
                    table = join.table;
                } else {
                    throw new IllegalArgumentException("undefined column [" + column + "]");
                }
            }
            RDBColumnMetadata metadata = col.metadata;
            if (col.metadata == null) {
                metadata = table.metadata;
            }
            String colName = col.metadata != null ? col.metadata.getName() : col.name;
            return metadata.findFeature(TermFragmentBuilder.createFeatureId((String)term.getTermType())).map(feature -> feature.createFragments(table.alias + "." + dialect.quote(colName, col.metadata != null), col.metadata, term)).orElse((SqlFragments)EmptySqlFragments.INSTANCE);
        }
    }

    static class ExpressionColumn
    extends QueryAnalyzer.Column {
        private final SelectItem expr;

        public ExpressionColumn(String alias, String owner, RDBColumnMetadata metadata, SelectItem expr) {
            super(alias, alias, owner, metadata);
            this.expr = expr;
        }
    }
}

