/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.cache.ReactiveCache;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.utils.TransactionUtils;
import org.reactivestreams.Publisher;
import org.springframework.transaction.reactive.TransactionSynchronization;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface EnableCacheReactiveCrudService<E, K>
extends ReactiveCrudService<E, K> {
    public ReactiveCache<E> getCache();

    @Override
    default public Mono<E> findById(K id) {
        return this.getCache().getMono((Object)("id:" + id), () -> ReactiveCrudService.super.findById(id));
    }

    @Override
    default public Mono<E> findById(Mono<K> publisher) {
        return publisher.flatMap(this::findById);
    }

    @Override
    default public Mono<Integer> updateById(K id, Mono<E> entityPublisher) {
        return this.registerClearCache("id:" + id).then(ReactiveCrudService.super.updateById(id, entityPublisher));
    }

    @Override
    default public Mono<SaveResult> save(E data) {
        return this.registerClearCache().then(ReactiveCrudService.super.save(data));
    }

    @Override
    default public Mono<SaveResult> save(Publisher<E> entityPublisher) {
        return this.registerClearCache().then(ReactiveCrudService.super.save(entityPublisher));
    }

    @Override
    default public Mono<Integer> insert(E data) {
        return this.registerClearCache().then(ReactiveCrudService.super.insert(data));
    }

    @Override
    default public Mono<Integer> insert(Publisher<E> entityPublisher) {
        return this.registerClearCache().then(ReactiveCrudService.super.insert(entityPublisher));
    }

    @Override
    default public Mono<Integer> insertBatch(Publisher<? extends Collection<E>> entityPublisher) {
        return this.registerClearCache().then(ReactiveCrudService.super.insertBatch(entityPublisher));
    }

    default public Mono<Void> registerClearCache() {
        return TransactionUtils.registerSynchronization(new TransactionSynchronization(){

            @Nonnull
            public Mono<Void> afterCommit() {
                return EnableCacheReactiveCrudService.this.getCache().clear();
            }
        }, TransactionSynchronization::afterCommit);
    }

    default public Mono<Void> registerClearCache(final String key) {
        return TransactionUtils.registerSynchronization(new TransactionSynchronization(){

            @Nonnull
            public Mono<Void> afterCommit() {
                return EnableCacheReactiveCrudService.this.getCache().evict((Object)key);
            }
        }, TransactionSynchronization::afterCommit);
    }

    @Override
    default public Mono<Integer> deleteById(Publisher<K> idPublisher) {
        final Flux cache = Flux.from(idPublisher).cache();
        return TransactionUtils.registerSynchronization(new TransactionSynchronization(){

            @Nonnull
            public Mono<Void> afterCommit() {
                return cache.flatMap(id -> EnableCacheReactiveCrudService.this.getCache().evict((Object)("id:" + id))).then();
            }
        }, TransactionSynchronization::afterCommit).then(ReactiveCrudService.super.deleteById(cache));
    }

    @Override
    default public ReactiveUpdate<E> createUpdate() {
        return ReactiveCrudService.super.createUpdate().onExecute((update, s) -> s.flatMap(i -> {
            if (i > 0) {
                return this.getCache().clear().thenReturn(i);
            }
            return Mono.just((Object)i);
        }));
    }

    @Override
    default public ReactiveDelete createDelete() {
        return ReactiveCrudService.super.createDelete().onExecute((update, s) -> s.flatMap(i -> {
            if (i > 0) {
                return this.getCache().clear().thenReturn(i);
            }
            return Mono.just((Object)i);
        }));
    }
}

