/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.utils;

import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.reactive.TransactionSynchronization;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import reactor.core.publisher.Mono;

public class TransactionUtils {
    private static final Logger log = LoggerFactory.getLogger(TransactionUtils.class);

    public static Mono<Void> registerSynchronization(TransactionSynchronization synchronization, Function<TransactionSynchronization, Mono<Void>> whenNoTransaction) {
        return TransactionSynchronizationManager.forCurrentTransaction().doOnNext(manager -> manager.registerSynchronization(synchronization)).then().onErrorResume(err -> {
            log.warn("register TransactionSynchronization [{}] error", (Object)synchronization, err);
            return (Mono)whenNoTransaction.apply(synchronization);
        });
    }
}

