/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hswebframework.web.crud.web.ResponseMessage;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestControllerAdvice
public class ResponseMessageWrapperAdvice
implements ResponseBodyAdvice<Object> {
    private Set<String> excludes = new HashSet<String>();

    public boolean supports(@Nonnull MethodParameter methodParameter, @Nonnull Class<? extends HttpMessageConverter<?>> aClass) {
        Class returnType;
        boolean isStream;
        if (methodParameter.getMethod() == null) {
            return true;
        }
        RequestMapping mapping = (RequestMapping)methodParameter.getMethodAnnotation(RequestMapping.class);
        if (mapping == null) {
            return false;
        }
        for (String produce : mapping.produces()) {
            MimeType mimeType = MimeType.valueOf((String)produce);
            if (!MediaType.TEXT_EVENT_STREAM.includes(mimeType) && !MediaType.APPLICATION_STREAM_JSON.includes(mimeType)) continue;
            return false;
        }
        if (!CollectionUtils.isEmpty(this.excludes) && methodParameter.getMethod() != null) {
            String typeName = methodParameter.getMethod().getDeclaringClass().getName() + "." + methodParameter.getMethod().getName();
            for (String exclude : this.excludes) {
                if (!typeName.startsWith(exclude)) continue;
                return false;
            }
        }
        if (isStream = Publisher.class.isAssignableFrom(returnType = methodParameter.getMethod().getReturnType())) {
            ResolvableType type = ResolvableType.forMethodParameter((MethodParameter)methodParameter);
            returnType = type.resolveGeneric(new int[]{0});
        }
        boolean isAlreadyResponse = returnType == ResponseMessage.class || returnType == ResponseEntity.class;
        return !isAlreadyResponse;
    }

    public Object beforeBodyWrite(Object body, @Nonnull MethodParameter returnType, @Nonnull MediaType selectedContentType, @Nonnull Class<? extends HttpMessageConverter<?>> selectedConverterType, @Nonnull ServerHttpRequest request, @Nonnull ServerHttpResponse response) {
        if (body instanceof Mono) {
            return ((Mono)body).map(ResponseMessage::ok).switchIfEmpty(Mono.fromSupplier(ResponseMessage::ok));
        }
        if (body instanceof Flux) {
            return ((Flux)body).collectList().map(ResponseMessage::ok).switchIfEmpty(Mono.fromSupplier(ResponseMessage::ok));
        }
        Method method = returnType.getMethod();
        if (method != null && returnType.getMethod().getReturnType() == String.class) {
            return JSON.toJSONString(ResponseMessage.ok(body));
        }
        return ResponseMessage.ok(body);
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }
}

