/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.ezorm.rdb.operator.dml.Terms;
import org.hswebframework.utils.RandomUtil;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSortSupportEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.service.TreeSortServiceHelper;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.id.IDGenerator;
import org.reactivestreams.Publisher;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.math.MathFlux;

public interface ReactiveTreeSortEntityService<E extends TreeSortSupportEntity<K>, K>
extends ReactiveCrudService<E, K> {
    default public Mono<List<E>> queryResultToTree(Mono<? extends QueryParamEntity> paramEntity) {
        return paramEntity.flatMap(this::queryResultToTree);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Mono<List<E>> queryResultToTree(QueryParamEntity paramEntity) {
        return this.query(paramEntity).collectList().map(list -> TreeSupportEntity.list2tree((Collection)list, this::setChildren, this::createRootNodePredicate));
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Mono<List<E>> queryIncludeChildrenTree(QueryParamEntity paramEntity) {
        return this.queryIncludeChildren(paramEntity).collectList().map(list -> TreeSupportEntity.list2tree((Collection)list, this::setChildren, this::createRootNodePredicate));
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Flux<E> queryIncludeChildren(Collection<K> idList) {
        return this.queryIncludeChildren(this.findById(idList));
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Flux<E> queryIncludeChildren(Flux<E> entities) {
        HashSet duplicateCheck = new HashSet();
        return entities.concatMap(e -> !StringUtils.hasText((String)e.getPath()) || !duplicateCheck.add(e.getPath()) ? Mono.just((Object)e) : ((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).like$("path", (Object)e.getPath())).fetch(), Integer.MAX_VALUE).distinct(TreeSupportEntity::getId);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Flux<E> queryIncludeParent(Collection<K> idList) {
        return this.queryIncludeParent(this.findById(idList));
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Flux<E> queryIncludeParent(Flux<E> entities) {
        HashSet duplicateCheck = new HashSet();
        return entities.concatMap(e -> !StringUtils.hasText((String)e.getPath()) || !duplicateCheck.add(e.getPath()) ? Mono.just((Object)e) : ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).accept(Terms.Like.reversal((String)"path", (String)e.getPath(), (boolean)false, (boolean)true))).notEmpty("path")).notNull("path")).fetch(), Integer.MAX_VALUE).distinct(TreeSupportEntity::getId);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Flux<E> queryIncludeChildren(QueryParamEntity queryParam) {
        HashSet duplicateCheck = new HashSet();
        return this.query(queryParam).concatMap(e -> !StringUtils.hasText((String)e.getPath()) || !duplicateCheck.add(e.getPath()) ? Mono.just((Object)e) : ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.createQuery().as(q -> {
            if (CollectionUtils.isNotEmpty((Collection)queryParam.getIncludes())) {
                q.select(queryParam.getIncludes().toArray(new String[0]));
            }
            if (CollectionUtils.isNotEmpty((Collection)queryParam.getExcludes())) {
                q.selectExcludes(queryParam.getExcludes().toArray(new String[0]));
            }
            return q;
        })).where()).like$("path", (Object)e.getPath())).fetch(), Integer.MAX_VALUE).distinct(TreeSupportEntity::getId);
    }

    @Override
    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> insert(Publisher<E> entityPublisher) {
        return this.insertBatch((Publisher<? extends Collection<E>>)Flux.from(entityPublisher).collectList());
    }

    @Override
    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> insert(E data) {
        return this.insertBatch((Publisher<? extends Collection<E>>)Flux.just(Collections.singletonList(data)));
    }

    @Override
    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> insertBatch(Publisher<? extends Collection<E>> entityPublisher) {
        return this.getRepository().insertBatch((Publisher)new TreeSortServiceHelper(this).prepare(Flux.from(entityPublisher).flatMapIterable(Function.identity())).buffer(this.getBufferSize()));
    }

    default public int getBufferSize() {
        return 200;
    }

    @Deprecated
    default public Mono<E> applyTreeProperty(E ele) {
        if (StringUtils.hasText((String)ele.getPath()) || ObjectUtils.isEmpty((Object)ele.getParentId())) {
            return Mono.just(ele);
        }
        return this.checkCyclicDependency(ele.getId(), ele).then(this.findById(ele.getParentId()).doOnNext(parent -> ele.setPath(parent.getPath() + "-" + RandomUtil.randomChar((int)4)))).thenReturn(ele);
    }

    @Deprecated
    default public Mono<E> checkCyclicDependency(K id, E ele) {
        if (ObjectUtils.isEmpty(id)) {
            return Mono.empty();
        }
        return this.queryIncludeChildren(Collections.singletonList(id)).doOnNext(e -> {
            if (Objects.equals(ele.getParentId(), e.getId())) {
                throw new ValidationException.NoStackTrace("parentId", "error.tree_entity_cyclic_dependency", new Object[0]);
            }
        }).then(Mono.just(ele));
    }

    @Deprecated
    default public Mono<Collection<E>> checkParentId(Collection<E> source) {
        Set idSet = source.stream().map(TreeSupportEntity::getId).filter(e -> !ObjectUtils.isEmpty((Object)e)).collect(Collectors.toSet());
        if (idSet.isEmpty()) {
            return Mono.just(source);
        }
        Set readyToCheck = source.stream().map(TreeSupportEntity::getParentId).filter(e -> !ObjectUtils.isEmpty((Object)e) && !idSet.contains(e)).collect(Collectors.toSet());
        if (readyToCheck.isEmpty()) {
            return Mono.just(source);
        }
        return ((ReactiveQuery)((ReactiveQuery)this.createQuery().select(new String[]{"id"})).in("id", readyToCheck)).fetch().doOnNext(e -> readyToCheck.remove(e.getId())).then(Mono.fromSupplier(() -> {
            if (!readyToCheck.isEmpty()) {
                throw new ValidationException("error.tree_entity_parent_id_not_exist", Collections.singletonList(new ValidationException.Detail("parentId", "error.tree_entity_parent_id_not_exist", (Object)readyToCheck)), new Object[0]);
            }
            return source;
        }));
    }

    @Deprecated
    default public void refactorChildPath(K id, Function<K, Collection<E>> childGetter, String path, Consumer<E> pathAccepter) {
        Collection<E> children = childGetter.apply(id);
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (TreeSortSupportEntity child : children) {
            if (ObjectUtils.isEmpty((Object)path)) {
                child.setPath(RandomUtil.randomChar((int)4));
            } else {
                child.setPath(path + "-" + RandomUtil.randomChar((int)4));
            }
            pathAccepter.accept(child);
            this.refactorChildPath(child.getId(), childGetter, child.getPath(), pathAccepter);
        }
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, transactionManager="connectionFactoryTransactionManager")
    default public Mono<SaveResult> save(Publisher<E> entityPublisher) {
        return new TreeSortServiceHelper(this).prepare(Flux.from(entityPublisher)).buffer(this.getBufferSize()).flatMap(arg_0 -> this.getRepository().save(arg_0)).reduce(SaveResult::merge);
    }

    @Deprecated
    default public Flux<E> tryRefactorPath(Flux<E> stream) {
        return new TreeSortServiceHelper(this).prepare(stream);
    }

    @Override
    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<SaveResult> save(Collection<E> collection) {
        return this.save((E)Flux.fromIterable(collection));
    }

    @Override
    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<SaveResult> save(E data) {
        return this.save((E)Flux.just(data));
    }

    @Override
    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> updateById(K id, Mono<E> entityPublisher) {
        return this.findById(id).map(e -> this.save((E)entityPublisher.doOnNext(data -> data.setId(id))).map(SaveResult::getTotal)).defaultIfEmpty((Object)Mono.just((Object)0)).flatMap(Function.identity());
    }

    @Override
    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> deleteById(K id) {
        return this.deleteById((Publisher<K>)Flux.just(id));
    }

    @Override
    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> deleteById(Publisher<K> idPublisher) {
        return (Mono)this.findById(Flux.from(idPublisher)).concatMap(e -> StringUtils.hasText((String)e.getPath()) ? ((ReactiveDelete)((ReactiveDelete)this.getRepository().createDelete().where()).like$(() -> ((TreeSortSupportEntity)e).getPath())).execute() : this.getRepository().deleteById(e.getId()), Integer.MAX_VALUE).as(MathFlux::sumInt);
    }

    public IDGenerator<K> getIDGenerator();

    public void setChildren(E var1, List<E> var2);

    default public List<E> getChildren(E entity) {
        return entity.getChildren();
    }

    default public Predicate<E> createRootNodePredicate(TreeSupportEntity.TreeHelper<E, K> helper) {
        return node -> {
            if (this.isRootNode(node)) {
                return true;
            }
            if (!ObjectUtils.isEmpty((Object)node.getParentId())) {
                return helper.getNode(node.getParentId()) == null;
            }
            return false;
        };
    }

    default public boolean isRootNode(E entity) {
        return ObjectUtils.isEmpty((Object)entity.getParentId()) || "-1".equals(String.valueOf(entity.getParentId()));
    }

    @Override
    default public ReactiveDelete createDelete() {
        return ReactiveCrudService.super.createDelete().onExecute((delete, executor) -> this.queryIncludeChildren((QueryParamEntity)((QueryParamEntity)delete.toQueryParam(QueryParamEntity::new)).includes(new String[]{"id", "path", "parentId"})).map(TreeSupportEntity::getId).buffer(200).concatMap(list -> ((ReactiveDelete)((ReactiveDelete)this.getRepository().createDelete().where()).in("id", (Collection)list)).execute(), Integer.MAX_VALUE).reduce((Object)0, Math::addExact));
    }
}

