/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.events.ContextKeys;
import org.hswebframework.ezorm.rdb.events.EventContext;
import org.hswebframework.ezorm.rdb.events.EventListener;
import org.hswebframework.ezorm.rdb.events.EventType;
import org.hswebframework.ezorm.rdb.mapping.DSLUpdate;
import org.hswebframework.ezorm.rdb.mapping.EntityColumnMapping;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.SyncQuery;
import org.hswebframework.ezorm.rdb.mapping.SyncRepository;
import org.hswebframework.ezorm.rdb.mapping.events.MappingContextKeys;
import org.hswebframework.ezorm.rdb.mapping.events.MappingEventTypes;
import org.hswebframework.ezorm.rdb.mapping.events.ReactiveResultHolder;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.web.api.crud.entity.Entity;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.crud.events.EntityCreatedEvent;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.event.AsyncEvent;
import org.hswebframework.web.event.GenericsPayloadApplicationEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Mono;

public class EntityEventListener
implements EventListener {
    @Autowired
    ApplicationEventPublisher eventPublisher;

    public String getId() {
        return "entity-listener";
    }

    public String getName() {
        return "\u5b9e\u4f53\u53d8\u66f4\u4e8b\u4ef6\u76d1\u542c\u5668";
    }

    public void onEvent(EventType type, EventContext context) {
        boolean single;
        if (context.get(MappingContextKeys.error).isPresent()) {
            return;
        }
        EntityColumnMapping mapping = context.get(MappingContextKeys.columnMapping).orElse(null);
        if (mapping == null || !Entity.class.isAssignableFrom(mapping.getEntityType()) || mapping.getEntityType().getAnnotation(EnableEntityEvent.class) == null) {
            return;
        }
        if (type == MappingEventTypes.insert_before) {
            single = context.get(MappingContextKeys.type).map("single"::equals).orElse(false);
            if (single) {
                this.handleSingleOperation(mapping.getEntityType(), context, EntityCreatedEvent::new);
            } else {
                this.handleBatchOperation(mapping.getEntityType(), context, EntityCreatedEvent::new);
            }
        }
        if (type == MappingEventTypes.save_before) {
            single = context.get(MappingContextKeys.type).map("single"::equals).orElse(false);
            if (single) {
                this.handleSingleOperation(mapping.getEntityType(), context, EntitySavedEvent::new);
            } else {
                this.handleBatchOperation(mapping.getEntityType(), context, EntitySavedEvent::new);
            }
        }
        if (type == MappingEventTypes.update_before) {
            this.handleUpdateBefore(context);
        }
        if (type == MappingEventTypes.delete_before) {
            this.handleDeleteBefore(context);
        }
    }

    protected Mono<Void> sendUpdateEvent(List<?> olds, EventContext context) {
        ArrayList<Entity> newValues = new ArrayList<Entity>(olds.size());
        EntityColumnMapping mapping = (EntityColumnMapping)context.get(MappingContextKeys.columnMapping).orElseThrow(UnsupportedOperationException::new);
        TableOrViewMetadata table = (TableOrViewMetadata)context.get(ContextKeys.table).orElseThrow(UnsupportedOperationException::new);
        RDBColumnMetadata idColumn = table.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElse(null);
        if (idColumn == null) {
            return Mono.empty();
        }
        for (Object old : olds) {
            Entity newValue = context.get(MappingContextKeys.instance).filter(Entity.class::isInstance).map(Entity.class::cast).orElseGet(() -> context.get(MappingContextKeys.updateColumnInstance).map(map -> FastBeanCopier.copy((Object)map, (Object)FastBeanCopier.copy((Object)old, (Class)mapping.getEntityType(), (String[])new String[0]), (String[])new String[0])).map(Entity.class::cast).orElse(null));
            if (newValue != null) {
                FastBeanCopier.copy(old, (Object)newValue, (Set)FastBeanCopier.include((String[])new String[]{idColumn.getAlias()}));
            }
            newValues.add(newValue);
        }
        EntityModifyEvent event = new EntityModifyEvent(olds, newValues, mapping.getEntityType());
        this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, event, new Class[]{mapping.getEntityType()}));
        return event.getAsync();
    }

    protected Mono<Void> sendDeleteEvent(List<?> olds, EventContext context) {
        EntityColumnMapping mapping = (EntityColumnMapping)context.get(MappingContextKeys.columnMapping).orElseThrow(UnsupportedOperationException::new);
        TableOrViewMetadata table = (TableOrViewMetadata)context.get(ContextKeys.table).orElseThrow(UnsupportedOperationException::new);
        EntityDeletedEvent deletedEvent = new EntityDeletedEvent(olds, mapping.getEntityType());
        this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, deletedEvent, new Class[]{mapping.getEntityType()}));
        return deletedEvent.getAsync();
    }

    protected void handleUpdateBefore(DSLUpdate<?, ?> update, EventContext context) {
        Object repo = context.get(MappingContextKeys.repository).orElse(null);
        if (repo instanceof ReactiveRepository) {
            context.get(MappingContextKeys.reactiveResultHolder).ifPresent(holder -> {
                AtomicReference updated = new AtomicReference();
                holder.after(v -> Mono.defer(() -> {
                    List _tmp = updated.getAndSet(null);
                    if (CollectionUtils.isNotEmpty((Collection)_tmp)) {
                        return this.sendUpdateEvent(_tmp, context);
                    }
                    return Mono.empty();
                }));
                holder.before(((ReactiveQuery)((ReactiveRepository)repo).createQuery().setParam(update.toQueryParam())).fetch().collectList().doOnSuccess(updated::set).then());
            });
        } else if (repo instanceof SyncRepository) {
            QueryParam param = update.toQueryParam();
            SyncRepository syncRepository = repo;
            List list = ((SyncQuery)syncRepository.createQuery().setParam(param)).fetch();
            this.sendUpdateEvent(list, context).block();
        }
    }

    protected void handleUpdateBefore(EventContext context) {
        context.get(ContextKeys.source()).ifPresent(dslUpdate -> this.handleUpdateBefore((DSLUpdate<?, ?>)dslUpdate, context));
    }

    protected void handleDeleteBefore(EventContext context) {
        context.get(ContextKeys.source()).ifPresent(dslUpdate -> {
            Object repo = context.get(MappingContextKeys.repository).orElse(null);
            if (repo instanceof ReactiveRepository) {
                context.get(MappingContextKeys.reactiveResultHolder).ifPresent(holder -> {
                    AtomicReference deleted = new AtomicReference();
                    holder.after(v -> Mono.defer(() -> {
                        List _tmp = deleted.getAndSet(null);
                        if (CollectionUtils.isNotEmpty((Collection)_tmp)) {
                            return this.sendDeleteEvent(_tmp, context);
                        }
                        return Mono.empty();
                    }));
                    holder.before(((ReactiveQuery)((ReactiveRepository)repo).createQuery().setParam(dslUpdate.toQueryParam())).fetch().collectList().doOnSuccess(deleted::set).then());
                });
            } else if (repo instanceof SyncRepository) {
                QueryParam param = dslUpdate.toQueryParam();
                SyncRepository syncRepository = repo;
                List list = ((SyncQuery)syncRepository.createQuery().setParam(param)).fetch();
                this.sendDeleteEvent(list, context).block();
            }
        });
    }

    protected void handleUpdateAfter(EventContext context) {
    }

    protected void handleBatchOperation(Class clazz, EventContext context, BiFunction<List<?>, Class, AsyncEvent> mapper) {
        context.get(MappingContextKeys.instance).filter(List.class::isInstance).map(List.class::cast).ifPresent(lst -> {
            Optional resultHolder;
            AsyncEvent event = (AsyncEvent)mapper.apply((List<?>)lst, clazz);
            Object repo = context.get(MappingContextKeys.repository).orElse(null);
            if (repo instanceof ReactiveRepository && (resultHolder = context.get(MappingContextKeys.reactiveResultHolder)).isPresent()) {
                ((ReactiveResultHolder)resultHolder.get()).after(v -> {
                    this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, (Object)event, new Class[]{clazz}));
                    return event.getAsync();
                });
                return;
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, (Object)event, new Class[]{clazz}));
            event.getAsync().block();
        });
    }

    protected void handleSingleOperation(Class clazz, EventContext context, BiFunction<List<?>, Class, AsyncEvent> mapper) {
        context.get(MappingContextKeys.instance).filter(Entity.class::isInstance).map(Entity.class::cast).ifPresent(entity -> {
            Optional resultHolder;
            AsyncEvent event = (AsyncEvent)mapper.apply(Collections.singletonList(entity), clazz);
            Object repo = context.get(MappingContextKeys.repository).orElse(null);
            if (repo instanceof ReactiveRepository && (resultHolder = context.get(MappingContextKeys.reactiveResultHolder)).isPresent()) {
                ((ReactiveResultHolder)resultHolder.get()).after(v -> {
                    this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, (Object)event, new Class[]{clazz}));
                    return event.getAsync();
                });
                return;
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new GenericsPayloadApplicationEvent((Object)this, (Object)event, new Class[]{clazz}));
            event.getAsync().block();
        });
    }
}

