/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.beans.ConstructorProperties;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResponseMessage<T>
implements Serializable {
    private static final long serialVersionUID = 8992436576262574064L;
    protected String message;
    protected T result;
    private int status;
    protected String code;
    protected Long timestamp = System.currentTimeMillis();

    public static <T> ResponseMessage<T> ok() {
        return ResponseMessage.ok(null);
    }

    public static <T> ResponseMessage<T> ok(T result) {
        return ResponseMessage.builder().result(result).status(200).code("success").build();
    }

    public static <T> ResponseMessage<T> error(String message) {
        return ResponseMessage.error("error", message);
    }

    public static <T> ResponseMessage<T> error(String code, String message) {
        return ResponseMessage.error(500, code, message);
    }

    public static <T> ResponseMessage<T> error(int status, String code, String message) {
        ResponseMessage<T> msg = new ResponseMessage<T>();
        msg.message = message;
        msg.code = code;
        msg.status = status;
        return msg;
    }

    public ResponseMessage<T> result(T result) {
        this.result = result;
        return this;
    }

    public static <T> ResponseMessageBuilder<T> builder() {
        return new ResponseMessageBuilder();
    }

    public String getMessage() {
        return this.message;
    }

    public T getResult() {
        return this.result;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCode() {
        return this.code;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @ConstructorProperties(value={"message", "result", "status", "code", "timestamp"})
    public ResponseMessage(String message, T result, int status, String code, Long timestamp) {
        this.message = message;
        this.result = result;
        this.status = status;
        this.code = code;
        this.timestamp = timestamp;
    }

    public ResponseMessage() {
    }

    public static class ResponseMessageBuilder<T> {
        private String message;
        private T result;
        private int status;
        private String code;
        private Long timestamp;

        ResponseMessageBuilder() {
        }

        public ResponseMessageBuilder<T> message(String message) {
            this.message = message;
            return this;
        }

        public ResponseMessageBuilder<T> result(T result) {
            this.result = result;
            return this;
        }

        public ResponseMessageBuilder<T> status(int status) {
            this.status = status;
            return this;
        }

        public ResponseMessageBuilder<T> code(String code) {
            this.code = code;
            return this;
        }

        public ResponseMessageBuilder<T> timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ResponseMessage<T> build() {
            return new ResponseMessage<T>(this.message, this.result, this.status, this.code, this.timestamp);
        }

        public String toString() {
            return "ResponseMessage.ResponseMessageBuilder(message=" + this.message + ", result=" + this.result + ", status=" + this.status + ", code=" + this.code + ", timestamp=" + this.timestamp + ")";
        }
    }
}

