/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web.reactive;

import java.util.List;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.exception.NotFoundException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveQueryController<E, K> {
    @Authorize(ignore=true)
    public ReactiveRepository<E, K> getRepository();

    @GetMapping(value={"/_query/no-paging"})
    @QueryAction
    default public Flux<E> query(QueryParamEntity query) {
        return ((ReactiveQuery)this.getRepository().createQuery().setParam((QueryParam)query)).fetch();
    }

    @PostMapping(value={"/_query/no-paging"})
    @QueryAction
    default public Flux<E> query(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMapMany(this::query);
    }

    @GetMapping(value={"/_count"})
    @QueryAction
    default public Mono<Integer> count(QueryParamEntity query) {
        return ((ReactiveQuery)this.getRepository().createQuery().setParam((QueryParam)query)).count();
    }

    @GetMapping(value={"/_query"})
    @QueryAction
    default public Mono<PagerResult<E>> queryPager(QueryParamEntity query) {
        if (query.getTotal() != null) {
            return ((ReactiveQuery)this.getRepository().createQuery().setParam(query.rePaging(query.getTotal().intValue()))).fetch().collectList().map(list -> PagerResult.of((int)query.getTotal(), (List)list, (QueryParam)query));
        }
        return ((ReactiveQuery)this.getRepository().createQuery().setParam((QueryParam)query)).count().flatMap(total -> {
            if (total == 0) {
                return Mono.just((Object)PagerResult.empty());
            }
            return this.query((QueryParamEntity)query.clone().rePaging(total.intValue())).collectList().map(list -> PagerResult.of((int)total, (List)list, (QueryParam)query));
        });
    }

    @PostMapping(value={"/_query"})
    @QueryAction
    default public Mono<PagerResult<E>> queryPager(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMap(q -> this.queryPager((QueryParamEntity)q));
    }

    @PostMapping(value={"/_count"})
    @QueryAction
    default public Mono<Integer> count(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMap(this::count);
    }

    @GetMapping(value={"/{id:.+}"})
    @QueryAction
    default public Mono<E> getById(@PathVariable K id) {
        return this.getRepository().findById(Mono.just(id)).switchIfEmpty(Mono.error(NotFoundException::new));
    }
}

