/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web.reactive;

import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.exception.NotFoundException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveServiceQueryController<E, K> {
    @Authorize(ignore=true)
    public ReactiveCrudService<E, K> getService();

    @GetMapping(value={"/_query/no-paging"})
    @QueryAction
    default public Flux<E> query(QueryParamEntity query) {
        return ((ReactiveQuery)this.getService().createQuery().setParam((QueryParam)query)).fetch();
    }

    @PostMapping(value={"/_query/no-paging"})
    @QueryAction
    default public Flux<E> query(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMapMany(this::query);
    }

    @GetMapping(value={"/_count"})
    @QueryAction
    default public Mono<Integer> count(QueryParamEntity query) {
        return ((ReactiveQuery)this.getService().createQuery().setParam((QueryParam)query)).count();
    }

    @GetMapping(value={"/_query"})
    @QueryAction
    default public Mono<PagerResult<E>> queryPager(QueryParamEntity query) {
        return this.getService().queryPager(query);
    }

    @PostMapping(value={"/_query"})
    @QueryAction
    default public Mono<PagerResult<E>> queryPager(@RequestBody Mono<QueryParamEntity> query) {
        return this.getService().queryPager(query);
    }

    @PostMapping(value={"/_count"})
    @QueryAction
    default public Mono<Integer> count(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMap(this::count);
    }

    @GetMapping(value={"/{id:.+}"})
    @QueryAction
    default public Mono<E> getById(@PathVariable K id) {
        return this.getService().findById(Mono.just(id)).switchIfEmpty(Mono.error(NotFoundException::new));
    }
}

