/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web.reactive;

import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.reactivestreams.Publisher;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveServiceSaveController<E, K> {
    @Authorize(ignore=true)
    public ReactiveCrudService<E, K> getService();

    @Authorize(ignore=true)
    default public E applyCreationEntity(Authentication authentication, E entity) {
        RecordCreationEntity creationEntity = (RecordCreationEntity)entity;
        creationEntity.setCreateTimeNow();
        creationEntity.setCreatorId(authentication.getUser().getId());
        return entity;
    }

    @Authorize(ignore=true)
    default public E applyModifierEntity(Authentication authentication, E entity) {
        RecordModifierEntity creationEntity = (RecordModifierEntity)entity;
        creationEntity.setModifyTimeNow();
        creationEntity.setModifierId(authentication.getUser().getId());
        return entity;
    }

    @Authorize(ignore=true)
    default public E applyAuthentication(E entity, Authentication authentication) {
        if (entity instanceof RecordCreationEntity) {
            entity = this.applyCreationEntity(authentication, entity);
        }
        if (entity instanceof RecordModifierEntity) {
            entity = this.applyModifierEntity(authentication, entity);
        }
        return entity;
    }

    @PatchMapping
    @SaveAction
    default public Mono<SaveResult> save(@RequestBody Flux<E> payload) {
        return (Mono)Authentication.currentReactive().flatMapMany(auth -> payload.map(entity -> this.applyAuthentication((E)entity, (Authentication)auth))).switchIfEmpty(payload).as(this.getService()::save);
    }

    @PostMapping(value={"/_batch"})
    @SaveAction
    default public Mono<Integer> add(@RequestBody Flux<E> payload) {
        return (Mono)Authentication.currentReactive().flatMapMany(auth -> payload.map(entity -> this.applyAuthentication((E)entity, (Authentication)auth))).switchIfEmpty(payload).collectList().as(this.getService()::insertBatch);
    }

    @PostMapping
    @SaveAction
    default public Mono<E> add(@RequestBody Mono<E> payload) {
        return Authentication.currentReactive().flatMap(auth -> payload.map(entity -> this.applyAuthentication((E)entity, (Authentication)auth))).switchIfEmpty(payload).flatMap(entity -> this.getService().insert((Publisher<E>)Mono.just((Object)entity)).thenReturn(entity));
    }

    @PutMapping(value={"/{id}"})
    @SaveAction
    default public Mono<Boolean> update(@PathVariable K id, @RequestBody Mono<E> payload) {
        return Authentication.currentReactive().flatMap(auth -> payload.map(entity -> this.applyAuthentication((E)entity, (Authentication)auth))).switchIfEmpty(payload).flatMap(entity -> this.getService().updateById(id, Mono.just((Object)entity))).thenReturn((Object)true);
    }
}

