/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web.reactive;

import java.util.List;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSortSupportEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.crud.service.ReactiveTreeSortEntityService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveTreeServiceQueryController<E extends TreeSortSupportEntity<K>, K> {
    @Authorize(ignore=true)
    public ReactiveTreeSortEntityService<E, K> getService();

    @GetMapping(value={"/_query/tree"})
    @QueryAction
    default public Mono<List<E>> findAllTree(QueryParamEntity paramEntity) {
        return this.getService().queryResultToTree(paramEntity);
    }

    @GetMapping(value={"/_query/_children"})
    @QueryAction
    default public Flux<E> findAllChildren(QueryParamEntity paramEntity) {
        return this.getService().queryIncludeChildren(paramEntity);
    }

    @GetMapping(value={"/_query/_children/tree"})
    @QueryAction
    default public Mono<List<E>> findAllChildrenTree(QueryParamEntity paramEntity) {
        return this.getService().queryIncludeChildrenTree(paramEntity);
    }

    @PostMapping(value={"/_query/tree"})
    @QueryAction
    default public Mono<List<E>> findAllTree(Mono<QueryParamEntity> paramEntity) {
        return this.getService().queryResultToTree(paramEntity);
    }

    @PostMapping(value={"/_query/_children"})
    @QueryAction
    default public Flux<E> findAllChildren(Mono<QueryParamEntity> paramEntity) {
        return paramEntity.flatMapMany(param -> this.getService().queryIncludeChildren((QueryParamEntity)param));
    }

    @PostMapping(value={"/_query/_children/tree"})
    @QueryAction
    default public Mono<List<E>> findAllChildrenTree(Mono<QueryParamEntity> paramEntity) {
        return paramEntity.flatMap(param -> this.getService().queryIncludeChildrenTree((QueryParamEntity)param));
    }
}

