/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.configuration;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.web.api.crud.entity.EntityFactory;
import org.hswebframework.web.crud.configuration.EasyormProperties;
import org.hswebframework.web.crud.configuration.EntityInfo;
import org.hswebframework.web.crud.configuration.EntityTableMetadataResolver;
import org.hswebframework.web.crud.entity.factory.MapperEntityFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class AutoDDLProcessor
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AutoDDLProcessor.class);
    private Set<EntityInfo> entities = new HashSet<EntityInfo>();
    @Autowired
    private DatabaseOperator operator;
    @Autowired
    private EasyormProperties properties;
    @Autowired
    private EntityTableMetadataResolver resolver;
    @Autowired
    private EntityFactory entityFactory;
    private boolean reactive;

    public void afterPropertiesSet() {
        if (this.entityFactory instanceof MapperEntityFactory) {
            MapperEntityFactory factory = (MapperEntityFactory)this.entityFactory;
            for (EntityInfo entityInfo : this.entities) {
                factory.addMapping(entityInfo.getEntityType(), MapperEntityFactory.defaultMapper(entityInfo.getRealType()));
            }
        }
        List entities = this.entities.stream().map(EntityInfo::getRealType).collect(Collectors.toList());
        if (this.properties.isAutoDdl()) {
            ((RDBSchemaMetadata)this.operator.getMetadata().getCurrentSchema()).loadAllTable();
            for (Class clazz : entities) {
                log.trace("auto ddl for {}", (Object)clazz);
                try {
                    this.operator.ddl().createOrAlter(this.resolver.resolve(clazz)).commit().sync();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        } else {
            for (Class clazz : entities) {
                RDBTableMetadata metadata = this.resolver.resolve(clazz);
                ((RDBSchemaMetadata)this.operator.getMetadata().getCurrentSchema()).addTable(metadata);
            }
        }
    }

    public Set<EntityInfo> getEntities() {
        return this.entities;
    }

    public DatabaseOperator getOperator() {
        return this.operator;
    }

    public EasyormProperties getProperties() {
        return this.properties;
    }

    public EntityTableMetadataResolver getResolver() {
        return this.resolver;
    }

    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public boolean isReactive() {
        return this.reactive;
    }

    public void setEntities(Set<EntityInfo> entities) {
        this.entities = entities;
    }

    public void setOperator(DatabaseOperator operator) {
        this.operator = operator;
    }

    public void setProperties(EasyormProperties properties) {
        this.properties = properties;
    }

    public void setResolver(EntityTableMetadataResolver resolver) {
        this.resolver = resolver;
    }

    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }
}

