/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.sql;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Statement;
import java.time.ZoneOffset;
import java.util.Date;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.reactive.r2dbc.R2dbcReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.web.datasource.DataSourceHolder;
import org.hswebframework.web.datasource.R2dbcDataSource;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.r2dbc.connectionfactory.ConnectionFactoryUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class DefaultR2dbcExecutor
extends R2dbcReactiveSqlExecutor {
    @Autowired
    private ConnectionFactory defaultFactory;
    private boolean bindCustomSymbol = false;
    private String bindSymbol = "$";

    public String getBindSymbol() {
        return this.bindSymbol;
    }

    protected SqlRequest convertRequest(SqlRequest sqlRequest) {
        if (this.bindCustomSymbol) {
            return super.convertRequest(sqlRequest);
        }
        return sqlRequest;
    }

    protected void bindNull(Statement statement, int index, Class type) {
        if (this.bindCustomSymbol) {
            statement.bindNull(this.getBindSymbol() + (index + this.getBindFirstIndex()), type);
            return;
        }
        statement.bindNull(index, type);
    }

    protected void bind(Statement statement, int index, Object value) {
        if (value instanceof Date) {
            value = ((Date)value).toInstant().atZone(ZoneOffset.systemDefault()).toLocalDateTime();
        }
        if (this.bindCustomSymbol) {
            statement.bind(this.getBindSymbol() + (index + this.getBindFirstIndex()), value);
            return;
        }
        statement.bind(index, value);
    }

    protected Mono<Connection> getConnection() {
        if (DataSourceHolder.isDynamicDataSourceReady()) {
            return DataSourceHolder.currentR2dbc().flatMap(R2dbcDataSource::getNative).flatMap(ConnectionFactoryUtils::getConnection);
        }
        return ConnectionFactoryUtils.getConnection((ConnectionFactory)this.defaultFactory);
    }

    protected void releaseConnection(SignalType type, Connection connection) {
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED, transactionManager="connectionFactoryTransactionManager")
    public Mono<Void> execute(Publisher<SqlRequest> request) {
        return super.execute(request);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    public Mono<Integer> update(Publisher<SqlRequest> request) {
        return super.update(request);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    public <E> Flux<E> select(Publisher<SqlRequest> request, ResultWrapper<E, ?> wrapper) {
        return super.select(request, wrapper);
    }

    public void setBindCustomSymbol(boolean bindCustomSymbol) {
        this.bindCustomSymbol = bindCustomSymbol;
    }

    public void setBindSymbol(String bindSymbol) {
        this.bindSymbol = bindSymbol;
    }
}

