/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.web.reactive;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import org.hswebframework.web.api.crud.entity.QueryOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSortSupportEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.crud.service.ReactiveTreeSortEntityService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveTreeServiceQueryController<E extends TreeSortSupportEntity<K>, K> {
    @Authorize(ignore=true)
    public ReactiveTreeSortEntityService<E, K> getService();

    @GetMapping(value={"/_query/tree"})
    @QueryAction
    @QueryOperation(summary="\u4f7f\u7528GET\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u6811\u5f62\u7ed3\u6784")
    default public Mono<List<E>> findAllTree(@Parameter(hidden=true) QueryParamEntity paramEntity) {
        return this.getService().queryResultToTree(paramEntity);
    }

    @GetMapping(value={"/_query/_children"})
    @QueryAction
    @QueryOperation(summary="\u4f7f\u7528GET\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u5b50\u8282\u70b9\u6570\u636e")
    default public Flux<E> findAllChildren(@Parameter(hidden=true) QueryParamEntity paramEntity) {
        return this.getService().queryIncludeChildren(paramEntity);
    }

    @GetMapping(value={"/_query/_children/tree"})
    @QueryAction
    @QueryOperation(summary="\u4f7f\u7528GET\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u5b50\u8282\u70b9\u6811\u5f62\u7ed3\u6784\u6570\u636e")
    default public Mono<List<E>> findAllChildrenTree(@Parameter(hidden=true) QueryParamEntity paramEntity) {
        return this.getService().queryIncludeChildrenTree(paramEntity);
    }

    @PostMapping(value={"/_query/tree"})
    @QueryAction
    @Operation(summary="\u4f7f\u7528POST\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u6811\u5f62\u7ed3\u6784")
    default public Mono<List<E>> findAllTree(Mono<QueryParamEntity> paramEntity) {
        return this.getService().queryResultToTree(paramEntity);
    }

    @PostMapping(value={"/_query/_children"})
    @QueryAction
    @Operation(summary="\u4f7f\u7528POST\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u5b50\u8282\u70b9\u6570\u636e")
    default public Flux<E> findAllChildren(Mono<QueryParamEntity> paramEntity) {
        return paramEntity.flatMapMany(param -> this.getService().queryIncludeChildren((QueryParamEntity)param));
    }

    @PostMapping(value={"/_query/_children/tree"})
    @QueryAction
    @Operation(summary="\u4f7f\u7528POST\u52a8\u6001\u67e5\u8be2\u5e76\u8fd4\u56de\u5b50\u8282\u70b9\u6811\u5f62\u7ed3\u6784\u6570\u636e")
    default public Mono<List<E>> findAllChildrenTree(Mono<QueryParamEntity> paramEntity) {
        return paramEntity.flatMap(param -> this.getService().queryIncludeChildrenTree((QueryParamEntity)param));
    }
}

